from sandbox import sdk2
from sandbox.projects.common import binary_task


class JupiterIntegrationData(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    ttl = 100


class JupiterCreateIntegrationData(binary_task.LastBinaryTaskRelease, sdk2.Task):
    """
    Task downloads sampled data from yt and uploads integration.tar to sandbox.
    """

    class Requirements(sdk2.Task.Requirements):
        disk_space = 40 * 1024  # Mb. Need x2 for raw data + integration.tar

    class Parameters(binary_task.LastBinaryReleaseParameters):
        _lbrp = binary_task.binary_release_parameters(stable=True)

        mr_prefix = sdk2.parameters.String("Mister Prefix", default="//home/jupiter")
        mr_server = sdk2.parameters.String("YT proxy (Mister Server)", default="arnold.yt.yandex.net")
        output = sdk2.parameters.String("Name of resulting tar file", default="integration.tar")
        sample_type = sdk2.parameters.String("Type of sample", default="integration")
        state = sdk2.parameters.String("Sample state to download", default="Last")
        yt_token_name = sdk2.parameters.String(
            "Name of the sandbox vault record storing yt token", default="jupiter_yt_token")
        yt_token_owner = sdk2.parameters.String(
            "Owner of the sandbox vault record storing yt token", default="JUPITER")

    def on_execute(self):
        from robot.jupiter.library.python.sample import download_test_data as dtd

        yt_token = sdk2.Vault.data(self.Parameters.yt_token_owner, self.Parameters.yt_token_name)
        dtd.create_test_data(
            self.Parameters.mr_server,
            self.Parameters.mr_prefix,
            self.Parameters.sample_type,
            self.Parameters.state,
            self.Parameters.output,
            download_kwargs={"yt_token": yt_token}
        )
        data = sdk2.ResourceData(JupiterIntegrationData(self, self.Parameters.output, self.Parameters.output))
        data.ready()
