from sandbox import sdk2

JUPITER_RELEASERS = ['JUPITER']


class JupiterResourceBase(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String
    any_arch = True
    auto_backup = True
    calc_md5 = True
    executable = False
    releasable = True
    releasers = JUPITER_RELEASERS
    share = True
    ttl = 100


class JupiterBinaries(JupiterResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/packages/binaries/ya.make
    """
    pass


class JupiterCmpy(JupiterResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/packages/cmpy/ya.make
    """
    pass


class JupiterConfigs(JupiterResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/packages/configs/ya.make
    """
    pass


class JupiterYandexBundle(JupiterResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/packages/yandex_bundle/ya.make
    """
    pass


class JupiterDessertBundle(JupiterResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/packages/dessert_bundle/ya.make
    """
    pass


class JupiterShardsPrepareBundle(JupiterResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/packages/shards_prepare_bundle/ya.make
    """
    pass


class JupiterGeminiSaasBundle(JupiterResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/packages/gemini_saas_bundle/ya.make
    """
    pass


class JupiterRtYandexBundle(JupiterResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/packages/rt_yandex_bundle/ya.make
    """
    pass


class JupiterCanonizedFactorsBundle(JupiterResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/packages/canonized_factors_bundle/ya.make
    """
    pass


class JupiterExternaldatHostBundle(JupiterResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/packages/externaldat_host_bundle/ya.make
    """
    pass


class JupiterHostdatBundle(JupiterResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/packages/hostdat_bundle/ya.make
    """
    pass


class JupiterYandexDeployBundle(JupiterResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/packages/yandex_deploy_bundle/ya.make
    """
    pass


class JupiterViewers(JupiterResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/packages/viewers/ya.make
    """
    pass


class DeliveryBinaries(JupiterResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/packages/delivery/ya.make
    """
    pass


class JupiterRunner(JupiterResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/tools/jupiter_runner/ya.make
    """
    pass


class JupiterCanonizer(JupiterResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/packages/canonizer/pkg.json
    """
    pass


class JupiterBundle(JupiterResourceBase):
    """
    Bundle for runtime cloud web base deploy
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/packages/shard_deploy_bundle/pkg.json
    """


class JupiterSaasShardDeployBundle(JupiterResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/packages/saas_shard_deploy_bundle/pkg.json
    """
    pass


class JupiterBraseroFiles(sdk2.Resource):
    """
    Files from fb-brasero.search.yandex.net for several jupiter deliveries
    - yaca/current/src/cat/c2p/cat.c2p
    - yaca/current/src/cat/c2p/dmoz.c2p
    - yaca/current/src/cat/c2p/genre.c2p
    - yaca/current/misc/geomap/geoBase.c2CountryRegion
    - yaca/current/misc/geomap/geo.c2CountryCity
    - yaca/current/src/cat/c2p/geo.c2p
    - yaca/current/index/pure/geoa.c2p
    - yaca/current/src/cat/c2p/onl.c2p
    - yaca/current/src/cat/c2p/sect.c2p
    - yaca/current/src/cat/c2p/src.c2p
    - yaca/current/src/cat/c2p/xxx.c2p
    - yaca/current/src/cat/c2p/common.c2p

    Old delivery states.
    JUPITER_BASE_SEARCH_BUNDLE:
    "delivery_state": {
        "by.query": "20110527-205936",
        "cat.c2p": "20180113-015051",
        "cat.c2s": "20110325-122307",
        "dmoz.c2p": "20141014-125355",
        "genre.c2p": "20180113-015051",
        "geo.c2CountryCity": "20180114-205515",
        "geo.c2p": "20180113-015051",
        "geo.c2s": "20110325-122307",
        "geo.stat": "20160912-193607",
        "geoBase.c2CountryRegion": "20180114-205515",
        "geoa.c2p": "20180113-121501",
        "kz.query": "20110527-205936",
        "onl.c2p": "20180113-015051",
        "porno.query": "20110325-122307",
        "sect.c2p": "20180113-015051",
        "src.c2p": "20180113-015051",
        "ua.query": "20110527-205936",
        "xxx.c2p": "20180113-015051"
    }

    JUPITER_SELECTION_RANK_BUNDLE:
    "delivery_state": {
        "2ld.list": "20200327-100641",
        "TestUploadHosts.txt": "20190312-161820",
        "common.c2p": "20180113-111157",
        "f2ld.list": "20130312-203611",
        "geocityurl.bin": "20140214-125054",
        "geocountryurl.bin": "20140214-125054",
        "gskUrlModel.batch": "20170227-141440",
        "ngrams_clusters.txt": "20170227-141440",
        "ngrams_model.info": "20170227-141440",
        "product.words": "20111206-220050",
        "rns.models.tsv.gz": "20170227-141440",
        "spl-grp.cfg": "20120914-182900",
        "subhost-owners.re": "20190613-193857",
        "towns": "20100119-180147",
        "ungrouped.list": "20131219-153326",
        "url_trigrams_model.bin": "20170227-141440"
    }

    JUPITER_QUERYREC_BUNDLE:
    "delivery_state": {
        "geo.c2p": "20180113-015051",
        "geo.stat": "20160912-193607",
        "geoa.c2p": "20180113-121501",
        "queryrec.dict": "20160722-170032",
        "queryrec.filters": "20120209-172231",
        "queryrec.weights": "20160722-170032"
    }
    """
    pass


class JupiterSelectionRankRuleFiles(JupiterResourceBase):
    pass
