# -*- coding: utf-8 -*-

from __future__ import absolute_import, print_function, division

from sandbox import sdk2
from sandbox.projects.resource_types import YA_PACKAGE as _YA_PACKAGE
from sandbox.projects.porto.common.resource_types import QEMU_IMAGE_SEARCH_BIONIC_DEVEL

CORE_TEAM = ('feriat', 'i024', 'hans', 'lipkin', 'monory')
ROBOTS = ('robot-jupyter-cloud', )
RELEASERS = CORE_TEAM + ROBOTS


class JUPYTER_ARCADIA_DEFAULT_KERNELS(_YA_PACKAGE):
    """
    Ресурс c архивом стандартных Аркадийных jupyter-ядер.
    """

    releasers = RELEASERS


class JUPYTER_ARCADIA_KERNELS_MANAGE(sdk2.Resource):
    """
    Ресурс для таска YA_MAKE_2 и сборки jupytercloud/arcadia_kernel/manage
    """

    executable = True
    auto_backup = True
    any_arch = False
    releasable = True
    releasers = RELEASERS


class QEMU_IMAGE_JUPYTER_CLOUD_MINION(QEMU_IMAGE_SEARCH_BIONIC_DEVEL):
    """
    Образ для виртуальных машин JupyterCloud
    """

    releasers = RELEASERS


class QEMU_IMAGE_JUPYTER_CLOUD_DEVEL_MINION(QEMU_IMAGE_SEARCH_BIONIC_DEVEL):
    """
    Образ для виртуальных машин JupyterCloud c дев-окружением (которое коннектится
    к другому солт-мастеру)
    """

    releasers = RELEASERS


class JUPYTER_CLOUD_BACKUP(sdk2.Resource):
    """
    Ресурс с зашифрованным бекапом для одного пользователя.
    """

    user = sdk2.parameters.String('Username')
    host = sdk2.parameters.String('Host')
