from __future__ import absolute_import, division, print_function

from sandbox import sdk2
from sandbox.common.errors import TaskFailure
from sandbox.common.types import resource as ctr

ENVIRONMENTS = {
    'testing': {
        'salt_masters': [
            'http://salt-sas.beta.jupyter.yandex-team.ru',
            'http://salt-iva.beta.jupyter.yandex-team.ru',
            'http://salt-myt.beta.jupyter.yandex-team.ru',
        ],
        'secret_id': 'sec-01dh6emwya97r6z2w8pc88m7a2',
    },
    'production': {
        'salt_masters': [
            'http://salt-sas.jupyter.yandex-team.ru',
            'http://salt-iva.jupyter.yandex-team.ru',
            'http://salt-myt.jupyter.yandex-team.ru',
        ],
        'secret_id': 'sec-01dhkemwckfe8tc5vbk1tps2yq',
    },
}

JUPYTERCLOUD_SHARED_SECRETS_ID = 'sec-01d83hjj2yehgykzn85n2h5pa5'


class JupyterCloud3Task(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        use_latest_sandbox_binary = sdk2.parameters.Bool(
            'Always use latest SANDBOX_TASKS_BINARY task resource',
            default=False,
            description='Makes sense for regular runs through Sandbox schedulers',
        )

        with sdk2.parameters.Group('YaVault options') as ya_vault_options:
            yav_shared_secret = sdk2.parameters.YavSecret(
                'YaVault generic secrets',
                required=True,
                default_value=JUPYTERCLOUD_SHARED_SECRETS_ID,
            )
            yav_prod_secret = sdk2.parameters.YavSecret(
                'YaVault prod secret',
                default_value=ENVIRONMENTS['production']['secret_id'],
            )
            yav_test_secret = sdk2.parameters.YavSecret(
                'YaVault test secret',
                default_value=ENVIRONMENTS['testing']['secret_id'],
            )

    def _set_tasks_resource(self):
        if (
            self.Requirements.tasks_resource is not None
            and not self.Parameters.use_latest_sandbox_binary
        ):
            return

        self.Requirements.tasks_resource = sdk2.service_resources.SandboxTasksBinary.find(
            state=ctr.State.READY,
            attrs=dict(
                task_type=self.type.name,
            ),
        ).first()

    def on_create(self):
        self._set_tasks_resource()

    def on_save(self):
        self._set_tasks_resource()

        if self.Requirements.tasks_resource is None:
            raise TaskFailure(
                'Failed to find proper {} resource to run'.format(
                    sdk2.service_resources.SandboxTasksBinary.name
                )
            )
