# coding: utf-8
from sandbox import sdk2
from sandbox.projects.common.build.YaMake import YaMakeTask

from sandbox.projects.common.build import parameters as build_params
from sandbox.projects.common.nanny import nanny

import sandbox.projects.jurassic.resource_types as resource_types

RESOURCES = {
    'agent': resource_types.JurassicAgentBinary,
    'model': resource_types.JurassicModelBinary,
    'proxy': resource_types.JurassicProxyBinary,
    'config': resource_types.JurassicConfig,
    'UI': resource_types.JurassicUIBundle,
}


class BuildJurassicArc(nanny.ReleaseToNannyTask, YaMakeTask):
    """
    Jurassic.
    """
    type = 'BUILD_JURASSIC_ARC'
    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.BuildType,
        build_params.CheckReturnCode,
        build_params.CheckoutModeParameter,
        build_params.CheckoutParameter,
        build_params.ClearBuild,
    ]

    class Parameters(sdk2.Parameters):
        with sdk2.parameters.CheckGroup("Select components") as multiselect:
            multiselect.values.option1 = multiselect.Value("Model", checked=True)
            multiselect.values.option2 = multiselect.Value("Agent", checked=True)
            multiselect.values.option3 = multiselect.Value("Proxy", checked=True)
            multiselect.values.option4 = multiselect.Value("Config", checked=True)
            multiselect.values.option5 = multiselect.Value("UI", checked=True)

    def get_resources(self):
        return {
            k: {'description': 'jurassic {}'.format(k), 'resource_path': k, 'resource_type': rtype}
            for k, rtype in RESOURCES.iteritems() if rtype.resource_build_type == 'arc'
        }

    def get_targets(self):
        return ['search/mon/jurassic']

    def get_arts(self):
        return [{'dest': '', 'path': "{}/{}".format(rtype.arcadia_build_path, k)}
                for k, rtype in RESOURCES.iteritems() if rtype.resource_build_type == 'arc']
