import os
import logging

from sandbox import sdk2
import sandbox.projects.jurassic.resource_types as jurassic_resource_types
from sandbox.projects.common.arcadia import sdk as arcadiasdk


RESOURCES = {
    'agent': jurassic_resource_types.JurassicAgentBinary,
    'config': jurassic_resource_types.JurassicConfig,
    'model': jurassic_resource_types.JurassicModelBinary,
    'proxy': jurassic_resource_types.JurassicProxyBinary,
    'UI': jurassic_resource_types.JurassicUIBundle,
}


class BuildJurassic(sdk2.Task):
    """
    Abstract Jurassic Bundle Class
    """
    class Requirements(sdk2.Requirements):
        disk_space = 3000  # 3G

    class Parameters(sdk2.Parameters):
        """
        Common Task Parameters
        """
        jurassic_path = sdk2.parameters.String("Jurassic Path", required=True, default="search/mon/jurassic")
        with sdk2.parameters.CheckGroup("Select components") as multiselect:
            multiselect.values.option1 = multiselect.Value("agent", checked=True)
            multiselect.values.option2 = multiselect.Value("config", checked=True)
            multiselect.values.option3 = multiselect.Value("model", checked=True)
            multiselect.values.option4 = multiselect.Value("proxy", checked=True)
            multiselect.values.option5 = multiselect.Value("UI", checked=True)
        ArcadiaUrl = sdk2.parameters.String("Arcdia URL", required=True, default="arcadia:/arc/trunk/arcadia")

    def on_execute(self):
        """
        Bundle Build function
        :return:
        """

        checkout_path = self.Parameters.jurassic_path
        arcadia_url = self.Parameters.ArcadiaUrl
        os.chdir(arcadiasdk.do_clone(task=self, arcadia_url=arcadia_url))
        arcadiasdk.svn.Arcadia.update(path=checkout_path, set_depth='empty')
        arcadiasdk.svn.Arcadia.update(path=checkout_path)
        if "option2".startswith(tuple(self.Parameters.multiselect)):
            agent_config = sdk2.ResourceData(jurassic_resource_types.JurassicConfig(self, 'jurassic conf', jurassic_resource_types.JurassicConfig.arcadia_build_path))
            agent_config.ready()
