# coding: utf-8

from sandbox import sdk2

from sandbox.projects.resource_types import search_priemka_releasers
from sandbox.projects.resource_types.releasers import marty

jurassic_releasers = marty + search_priemka_releasers


class JurassicResource(sdk2.Resource):
    """
    Abstract Jurassic resource.
    """
    releasable = True
    any_arch = False
    releasers = jurassic_releasers
    auto_backup = True


class JurassicModelBinary(JurassicResource):
    """
    Jurassic model  binary.
    """
    arcadia_build_path = 'search/mon/jurassic/Backend/src/model'
    resource_build_type = 'arc'


class JurassicAgentBinary(JurassicResource):
    """
    Jurassic agent binary.
    """
    arcadia_build_path = 'search/mon/jurassic/Backend/src/agent'
    resource_build_type = 'arc'


class JurassicProxyBinary(JurassicResource):
    """
    Jurassic proxy binary.
    """
    arcadia_build_path = 'search/mon/jurassic/Backend/src/proxy'
    resource_build_type = 'arc'


class JurassicConfig(JurassicResource):
    """
    Jurassic config at .config/agent.config.yaml
    """
    arcadia_build_path = 'search/mon/jurassic/Backend/.config/agent.config.yaml'
    resource_build_type = 'svn'


class JurassicUIBundle(JurassicResource):
    """
    Archived Jurassic UI
    """
    arcadia_build_path = 'search/mon/jurassic/UI'
    resource_build_type = 'node'
