import datetime
import requests
import smtplib
import logging

from email.mime.multipart import MIMEMultipart
from email.mime.application import MIMEApplication

from sandbox import sdk2

DEFAULT_PIVOT_REPORT_PERIOD = 7
STARTREK_API_URL = 'https://st-api.yandex-team.ru'
STARTREK_QUEUES = ['OPG', 'CTR', 'BIPA']
SMTP_SERVER = 'smtp.yandex-team.ru'
SMTP_SERVER_PORT = 465
EMAIL_LOGIN = 'robot-sydney-k50@yandex-team.ru'
REPORT_RECIPIENTS = ['zcoder@yandex-team.ru', 'r4start@yandex-team.ru', 'tralvor@yandex-team.ru',
                     'dmitry-korol@yandex-team.ru']
PIVOT_REPORT_URL = '/v2/reports/_pivot'


class BuildPivotReportTask(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):

        date_to_str = sdk2.parameters.String('Date to YYYY-MM-DD, if empty will take current date')
        period = sdk2.parameters.Integer('Period for report', default=DEFAULT_PIVOT_REPORT_PERIOD, required=True)
        st_oauth_token = sdk2.parameters.YavSecret('Startrek OAuth Token', required=True)
        st_api_url = sdk2.parameters.String('Startrek API URL', default=STARTREK_API_URL, required=True)
        st_queues = sdk2.parameters.List('Startrek queues', default=STARTREK_QUEUES, required=True)
        email_login = sdk2.parameters.String('Email login', default=EMAIL_LOGIN, required=True)
        email_password = sdk2.parameters.YavSecret('Email password', required=True)
        email_subject = sdk2.parameters.String('Email subject', default='Performance report')
        report_recipients = sdk2.parameters.List('Report recipients', default=REPORT_RECIPIENTS)

    def on_execute(self):
        if self.Parameters.date_to_str:
            date_to = datetime.datetime.strptime(self.Parameters.date_to_str, '%Y-%m-%d')
            date_to = datetime.date(date_to.year, date_to.month, date_to.day)
        else:
            date_to = datetime.date.today()

        date_from = date_to - datetime.timedelta(days=self.Parameters.period)
        queues = ','.join(self.Parameters.st_queues)
        logging.info(queues)
        url = '{}{}?from={}&to={}&format=xlsx&queue={}'.format(self.Parameters.st_api_url, PIVOT_REPORT_URL, date_from,
                                                               date_to, queues)
        logging.debug(url)
        st_token = self.Parameters.st_oauth_token.data()['token']
        headers = {'Authorization': 'OAuth {}'.format(st_token),
                   'Content-Type': 'application/json',
                   'Cache-Control': 'no-cache'}
        r = requests.get(url, headers=headers, timeout=35)

        if r.status_code != requests.codes.ok or r.headers['Content-Type'] == 'application/json':
            raise Exception('Bad startrek response: {}'.format(r.content))

        email_password = self.Parameters.email_password.data()['password']

        msg = MIMEMultipart()
        msg['Subject'] = '[{} / {}] {}'.format(date_from, date_to, self.Parameters.email_subject)
        msg['From'] = self.Parameters.email_login
        msg['To'] = ', '.join(self.Parameters.report_recipients)

        attach = MIMEApplication(r.content)
        attach.add_header('Content-Disposition', 'attachment; filename=report.xlsx')
        msg.attach(attach)

        smtp_server = smtplib.SMTP_SSL(host=SMTP_SERVER, port=SMTP_SERVER_PORT)
        smtp_server.login(self.Parameters.email_login, email_password)
        smtp_server.sendmail(self.Parameters.email_login, self.Parameters.report_recipients, msg.as_string())
        smtp_server.quit()
