import sys
import json


def reducer(input_content):
    prev_upload_time = None
    prev_date = None
    current_query_id = None
    query_finish = False
    for line in input_content:
        row = json.loads(line)
        if current_query_id is None or current_query_id != row["_k50_query_id"] or prev_date != row.get("_k50_date"):
            current_query_id = row["_k50_query_id"]
            prev_date = row.get("_k50_date")
            prev_upload_time = None
            query_finish = False

        if not query_finish:
            if prev_upload_time is None or row["_k50_uploaded_at"] == prev_upload_time:
                prev_upload_time = row["_k50_uploaded_at"]
                prev_date = row.get("_k50_date")
                print(line)
            else:
                query_finish = True


if __name__ == '__main__':
    reducer(sys.stdin)
