# -*- coding: UTF-8 -*-

import functools
import logging
import time


def retry(exception_to_check, infinity_exception=None, tries=5, delay=10, backoff=1.5):
    def deco_retry(f):
        @functools.wraps(f)
        def f_retry(*args, **kwargs):
            mtries, mdelay = tries, delay
            while mtries > 1:
                try:
                    return f(*args, **kwargs)
                except exception_to_check as e:
                    decrement_tries = 1
                    if infinity_exception is not None:
                        for cls in infinity_exception:
                            if isinstance(e, cls):
                                decrement_tries = 0
                                break
                    logging.info("%r, retry in %r seconds...", e, mdelay)
                    time.sleep(mdelay)
                    mtries -= decrement_tries
                    mdelay *= backoff
            return f(*args, **kwargs)
        return f_retry
    return deco_retry
