# -*- coding: UTF-8 -*-

from sandbox import sdk2


kikimr_releasers = ["wint", "stunder", "mbabich"]
kikimr_tools_releasers = kikimr_releasers + ['artgromov', 'xifos']
ydb_cli_releasers = ["YDB"]


class KikimrPackage(sdk2.Resource):
    """Kikimr package"""
    releasable = True
    releasers = kikimr_releasers
    branch = sdk2.parameters.String("Branch")
    build_type = sdk2.parameters.String("Build type")
    platform = sdk2.parameters.String("Platform")
    resource_name = sdk2.parameters.String("Resource name")
    resource_version = sdk2.parameters.String("Resource version")
    svn_path = sdk2.parameters.String("Svn path")
    svn_revision = sdk2.parameters.String("Svn revision")


class KikimrBinaryPackage(KikimrPackage):
    """Kikimr Binary Package"""
    releasers = None


class KikimrConfigPackage(KikimrPackage):
    """Kikimr Config Package"""
    releasers = None


class KikimrUdfPackage(KikimrPackage):
    """Kikimr Udf Package"""
    releasers = None


class KikimrYcBinary(sdk2.Resource):
    """Kikimr Yandex Cloud CLI Binary"""
    releasable = True
    releasers = kikimr_releasers


class KikimrPackerStaffInfo(sdk2.Resource):
    """Staff-info for building YC image"""
    auto_backup = True


class KikimrRollingRestartBinary(sdk2.Resource):
    """kikimr_rolling_restart binary"""
    releasable = True
    releasers = kikimr_tools_releasers
    any_arch = True
    executable = True
    auto_backup = True


class KikimrJugglerBundle(sdk2.Resource):
    releasable = True
    releasers = kikimr_tools_releasers
    executable = True
    auto_backup = True


class YdbBackupData(sdk2.Resource):
    """ydb_backup data files"""
    releasable = False
    releasers = None
    any_arch = True
    executable = False
    auto_backup = True
    ttl = 180
    ydb_endpoint = sdk2.parameters.String("YDB endpoint")
    ydb_database = sdk2.parameters.String("YDB database name")
    ydb_path = sdk2.parameters.String("Path to backuped table or directory")
    ydb_schema_only = sdk2.parameters.Bool("Backup contains only schema")


class YdbCliBinary(sdk2.Resource):
    """YDB CLI binary"""
    releasable = True
    releasers = ydb_cli_releasers
    any_arch = False
    executable = True


class YdbStressToolBinary(sdk2.Resource):
    """ydb_stress_tool binary"""
    releasable = True
    releasers = kikimr_tools_releasers + ["va-kuznecov"]
    any_arch = False
    executable = True
