# -*- coding: UTF-8 -*-

from sandbox import sdk2
from sandbox.projects.kikimr.common.build import KikimrBuildYaPackage
from sandbox.projects.kikimr.resources import KikimrConfigPackage


class KikimrBuildConfigPackage(KikimrBuildYaPackage):
    """
    Build Kikimr Config Package
    """
    class Parameters(KikimrBuildYaPackage.Parameters):
        package_path = sdk2.parameters.String(
            "Package path",
            required=True,
            default_value="kikimr/testing/packages/multi-tenant/kikimr_multitenancy_cluster/pkg.json"
        )

    class CustomParameters(KikimrBuildYaPackage.CustomParameters):
        output_resource = KikimrConfigPackage.name

    def on_execute(self):
        self.CustomParameters.package_path = self.Parameters.package_path
        super(KikimrBuildConfigPackage, self).on_execute()
