#!/usr/bin/env python
# -*- coding: UTF-8 -*-
from __future__ import print_function
import os
import logging
import urllib2

import sandbox.common.errors as ce
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.sdk2.helpers import ProcessLog

logger = logging.getLogger('sandbox-task')
logger.setLevel(logging.DEBUG)


logger_sp = logging.getLogger('sandbox-subprocess')
logger_sp.setLevel(logging.DEBUG)


class KikimrRunSSH(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        disk_space = 1024
        cores = 1
        ram = 1024

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        description = 'Run ssh command (with key in Vault)'

        ssh_user = sdk2.parameters.String('SSH username', required=True)
        ssh_host = sdk2.parameters.String('SSH host', required=True)
        ssh_cmd = sdk2.parameters.String('SSH cmd', required=True)

        ssh_key_vault_owner = sdk2.parameters.String('Name of sandbox vault owner for robot ssh key', required=True)
        ssh_key_vault_entry = sdk2.parameters.String('Name of sandbox vault entry for robot ssh key', required=True)
        ssh_cssh = sdk2.parameters.Bool('Use cssh for connection through Bastion', default=False)
        ssh_cssh_download_url = sdk2.parameters.String('Url to download cssh (default: https://s3.mds.yandex.net/bastion/cssh)', default='https://s3.mds.yandex.net/bastion/cssh')

    def on_execute(self):
        logger.debug('calling on_execute')

        cmd = []

        if self.Parameters.ssh_cssh:
            cssh_path = os.path.abspath('./cssh')
            with open(cssh_path, 'w') as file:
                file.write(urllib2.urlopen(self.Parameters.ssh_cssh_download_url).read())
            os.chmod(cssh_path, 0775)
            cmd += [cssh_path]
        else:
            cmd += ['/usr/bin/ssh']

        cmd += [self.Parameters.ssh_user+'@'+self.Parameters.ssh_host]
        cmd += [self.Parameters.ssh_cmd]

        msg = 'Run command: %s.' % cmd
        logger.debug(msg)
        self.set_info(msg)

        with sdk2.ssh.Key(self, self.Parameters.ssh_key_vault_owner, self.Parameters.ssh_key_vault_entry):
            with ProcessLog(self, logger=logger_sp) as pl:
                proc = sp.Popen(cmd, shell=False, stdout=pl.stdout, stderr=pl.stdout)
                proc.communicate()
                if proc.returncode != 0:
                    msg = 'Command failed with returncode %s.' % proc.returncode
                    logger.debug(msg)
                    raise ce.TaskError(msg)

        self.set_info('Done')
