import requests
import json


class Solomon(object):
    endpoint = "http://solomon.yandex.net/api/v2/push"

    def __init__(self, token, project, service, cluster):
        self.token = token
        self.project = project
        self.service = service
        self.cluster = cluster
        self.sensors = []
        self.common_labels = []

    def to_json(self):
        return

    def push(self):
        body = {}
        if self.common_labels:
            body['commonLabels'] = self.common_labels

        if self.sensors:
            body['sensors'] = self.sensors
        else:
            raise Exception("Sensors can not be empty")
        print(json.dumps(body))
        return self._make_request('POST', json=body)

    def add_sensor(self, labels, ts, value):
        self.sensors.append({
            'labels': labels,
            'ts': ts,
            'value': value
        })

    def _make_request(self, method, **kwargs):
        headers = {
            "Authorization": "OAuth " + self.token
        }
        print(headers)

        params = {
            'project': self.project,
            'cluster': self.cluster,
            'service': self.service
        }

        try:
            res = requests.request(method,
                                   self.endpoint,
                                   headers=headers,
                                   params=params,
                                   **kwargs)
            res.raise_for_status()
        except Exception as ex:
            print(ex)
            raise
        return res.json()
