import logging
import time
from sandbox import sdk2
from sandbox.sdk2 import yav
from sandbox.projects.kinopoisk.PingdomSynchronization.Solomon import Solomon
from sandbox.projects.kinopoisk.PingdomSynchronization.Pingdom import PingdomCredentials, Pingdom


class PingdomSynchronization(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        disk_space = 5 * 1024  # 5 GB

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 10 * 60
        description = "Sync date from pingdom account to solomon"

        period = sdk2.parameters.Integer("Number of days to collect metrics for", required=True, default=30)

        with sdk2.parameters.Group("Solomon parameters") as solomon_params:
            cluster = sdk2.parameters.String("Cluster", required=True, default="pingdom")
            project = sdk2.parameters.String("Project", required=True, default="kinopoisk")
            service = sdk2.parameters.String("Service", required=True, default="sla")
            solomon_oauth = sdk2.parameters.String("Yav secret with solomon token", required=True)

        with sdk2.parameters.Group("Pingdom parameters") as pingdom_params:
            pingdom_secrets = sdk2.parameters.String("Yav secret with pingdom secrets", required=True)

    def on_execute(self):
        solomon_secrets = yav.Secret(self.Parameters.solomon_oauth)
        pingdom_secrets = yav.Secret(self.Parameters.pingdom_secrets)

        logging.info("Hello")
        sl = Solomon(solomon_secrets.data()['solomon_oauth_token'], self.Parameters.project, self.Parameters.service,
                     self.Parameters.cluster)
        creds = PingdomCredentials(pingdom_secrets.data()['Login'],
                                   pingdom_secrets.data()['Password'],
                                   pingdom_secrets.data()['API_AppKey']
                                   )

        day = 24 * 60 * 60
        end = time.time()
        start = end - day * self.Parameters.period

        pg = Pingdom(creds)
        for check in pg.checks.keys():
            logging.info('Adding {}'.format(check))
            sl.add_sensor({'check_name': check, 'sla': 'uptime'}, end,
                          pg.check_uptime(check, start, end))
            sl.add_sensor({'check_name': check, 'sla': 'mins_down'}, end,
                          pg.mins_down(check, start, end))

        sl.push()
