# import sys
import requests
import logging
import time

from sandbox import sdk2

# Suppress InsecureRequestWarning: Unverified HTTPS request
requests.packages.urllib3.disable_warnings(requests.packages.urllib3.exceptions.InsecureRequestWarning)

whitelist_url = 'https://kp-graphql-api.tst.kp.yandex.net/whitelist'  # os.environ['WHITELIST_URL'].strip()
target_graphql_url_default = 'https://kp-graphql-api.tst.kp.yandex.net/graphql'  # os.environ['TARGET_GRAPHQL_URL'].strip()

logging.basicConfig(level=logging.DEBUG)


def default_value_by_type(type_):
    if type_ == 'Long':
        return 1
    elif type_ == 'Int':
        return 1
    elif type_ == 'Boolean':
        return 'true'
    elif type_ == 'String':
        return ""
    elif type_ == 'ID':
        return ""
    elif type_ == 'Float':
        return 1.0
    elif type_ == '[Int]':
        return [1]
    elif type_ == '[Long]':
        return [1]
    elif type_ == '[Boolean]':
        return ['true']
    elif type_ == '[ID]':
        return [""]
    elif type_ == '[Float]':
        return [1.0]
    elif type_ == '[String]':
        return [""]
    # custom type
    elif type_ == 'UserReviewOrderBy':
        return 'CREATED_AT_DESC'
    elif type_ == 'TriviaType':
        return 'BLOOPER'
    elif type_ == 'CriticReviewType':
        return 'POSITIVE'
    elif type_ == '[CriticReviewType]':
        return ['POSITIVE']
    elif type_ == 'UserReviewType':
        return 'POSITIVE'
    elif type_ == '[UserReviewType]':
        return ['POSITIVE']
    elif type_ == 'LocalDate':
        return '2018-02-19'
    elif type_ == 'MovieMatchingQueryInput':
        return {'titles': ['']}
    elif type_ == '[MovieCrewRoleSlug]':
        return ['ACTOR']
    elif type_ == '[RelatedMovieType]':
        return ['DEFAULT']

    elif True:
        raise ValueError('Unknown type!')


def get_variables(query):
    variables_ = {}

    all_vars = query[query.find("(") + 1:query.find(")")]

    for x in all_vars.split("$"):
        tokens = x.split(":")
        for i in range(1, len(tokens)):
            if tokens[i].find("!") > 0:
                var_ = tokens[i - 1].strip()
                type_ = tokens[i].replace("!", "").replace(",", "").strip()
                variables_[var_] = default_value_by_type(type_)

    return variables_


def validate_response(response_query):
    code = response_query.status_code
    if code > 200:
        raise ValueError('Response code > 200')

    json = response_query.json()

    errors_ = json.get('errors')
    if errors_ is not None:
        message = errors_[0]['message']
        nameError = errors_[0]['extensions']['classification']
        if nameError == 'ValidationError' or nameError == 'ForbiddenQueryError':
            raise ValueError('ValidationError or ForbiddenQueryError')
        logging.debug(message)
    else:
        logging.debug("Looks ok")


def main(target_graphql_url):
    try:
        logging.debug("Request whitelist")
        whitelist = requests.get(
            url=whitelist_url,
            verify=False,
            headers={'X-Ya-Service-Ticket-Debug': 'DEBUG', 'Content-Type': 'application/json'},
        ).json()
        logging.debug("Try request queries to " + target_graphql_url)
        for content in whitelist:
            query = content['query']
            logging.debug("Current " + str(query))

            if query.startswith("query Tv($tvSeriesId: Long!)"):
                # todo delete after https://st.yandex-team.ru/KP-21349
                continue
            if query.startswith("query MovieDetails("):
                if "$imagesListLimit" in query:
                    # todo delete after https://st.yandex-team.ru/KP-21349
                    continue

            variables = get_variables(query)
            response_query = requests.post(
                url=target_graphql_url,
                verify=False,
                json={'query': query, 'variables': variables},
                headers={'X-Ya-Service-Ticket-Debug': 'DEBUG', 'Content-Type': 'application/json'},
            )
            logging.debug("Response " + str(response_query.json()))
            validate_response(response_query)

    except ValueError as e:
        logging.error(str(e))
        exit(1)

    logging.info("Happy end!")


class GraphqlChecker(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 2
        ram = 4  # 2GiB

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 60 * 60
        max_restarts = 3
        description = "Take whitelist queries and test pr to pass it"

        sleep_timeout = sdk2.parameters.Integer("Number of second to wait while realease machine will raise pr",
                                                default=10)
        arcanum_review_id = sdk2.parameters.Integer("Arcanum pr_id")

    def on_execute(self):
        logging.debug("START")
        sleep_timeout = self.Parameters.sleep_timeout
        logging.debug("SLEEP FOR " + str(sleep_timeout))
        time.sleep(sleep_timeout)
        logging.debug("WAKE UP")

        pr_id = self.Parameters.arcanum_review_id

        target_graphql_url = target_graphql_url_default
        if pr_id is not None:
            target_graphql_url = "http://backend-1.backend.pr-" + str(
                pr_id) + ".kp-graphql-api.kinopoisk.stable.qloud-d.yandex.net/graphql"
        main(target_graphql_url)
