from sandbox import sandboxsdk
from sandbox.projects.common import constants as consts
from sandbox.projects.common.build import YaPackage


class KinopoiskPrYaPackage(YaPackage.YaPackage):
    type = 'KINOPOISK_PR_YA_PACKAGE'
    cores = 2

    def on_enqueue(self):
        YaPackage.YaPackage.on_enqueue(self)

        revision = sandboxsdk.svn.Arcadia\
            .parse_url(self.ctx.get(YaPackage.parameters.ArcadiaUrl.name)).revision or 'UNKNOWN'
        arcanum_review_id = self.ctx.get('arcanum_review_id')
        arcadia_patch = self.ctx.get(consts.ARCADIA_PATCH_KEY)

        if arcanum_review_id and arcadia_patch:
            self.ctx[YaPackage.CustomVersionParameter.name] = \
                "pr-%s.%s.%d" % (arcanum_review_id, revision, self.id)
