import re

from sandbox import sdk2
from sandbox.projects.release_machine.helpers import qloud_helper, arcanum_helper


class KinopoiskArcanumApi(arcanum_helper.ArcanumApi):

    def get_review_request(self, rr_id):
        return self._do_get(
            "v1/review-requests/{}".format(rr_id),
            params={
                'fields': 'id,state'
            })


class KinopoiskQloudUnstableFromPrClean(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 1

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Parameters):
        qloud_project = sdk2.parameters.String('Qloud project name')
        qloud_application = sdk2.parameters.String('Qloud application name')
        qloud_environment_to_pr_format = sdk2.parameters.String(
            'Regex with one group for matching from environment name to Arcanum PR id',
            default='pr\\-(\\d+)'
        )

        qloud_vault_name = sdk2.parameters.String("Vault name of qloud oauth token")
        qloud_vault_owner = sdk2.parameters.String("Owner name of qloud oauth token")

        arcanum_vault_name = sdk2.parameters.String("Vault name of arcanum oauth token")
        arcanum_vault_owner = sdk2.parameters.String("Owner name of arcanum oauth token")

    def on_execute(self):
        qloud_token = sdk2.Vault.data(self.Parameters.qloud_vault_owner, self.Parameters.qloud_vault_name)
        arcanum_token = sdk2.Vault.data(self.Parameters.arcanum_vault_owner, self.Parameters.arcanum_vault_name)
        qloud_api = qloud_helper.QloudPublicApi(qloud_token)
        arcanum_api = KinopoiskArcanumApi(token=arcanum_token)

        pr_pattern = re.compile(str(self.Parameters.qloud_environment_to_pr_format))

        app_id = '.'.join([str(self.Parameters.qloud_project), str(self.Parameters.qloud_application)])

        env_ids = [env['objectId'].split('.')[2] for env in qloud_api.list_environments(app_id)['environments']]

        env_pr_pairs = []
        for env in env_ids:
            match = pr_pattern.match(env)
            if match is not None:
                env_pr_pairs.append((env, int(match.group(1))))

        self.set_info("Found PR-based environments: {}".format(env_pr_pairs))

        for env, pr_id in env_pr_pairs:
            request = arcanum_api.get_review_request(pr_id)
            if request['data']['state'] == 'closed':
                env_id = '.'.join([app_id, env])
                self.set_info("PR {} is closed. Removing environment: {}".format(pr_id, env_id))
                qloud_api.delete_environment(env_id)
