# -*- encoding: utf8 -*-

from sandbox import sdk2

kwyt_releasers = [
    'izetag',
    'robot-kwyt',
    'zagevalo',
    'antervis',
    'gous32',
    'alex-stanovoy',
    'robot-srch-releaser',
    'akhovrychev',
]

kwyt_subscribers = ['kwyt-releases']


class KwytCmPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = kwyt_releasers
    release_subscribers = kwyt_subscribers


class KwytDiff(sdk2.Resource):
    '''
    Files with integration test diff
    '''
    auto_backup = True


class KwytViewerFullPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = kwyt_releasers
    release_subscribers = kwyt_subscribers


class FiltersViewerPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = kwyt_releasers
    release_subscribers = kwyt_subscribers


class KwytqlBin(sdk2.Resource):
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = False
    releasers = kwyt_releasers
    release_subscribers = kwyt_subscribers


class SelectqlBin(sdk2.Resource):
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = False
    releasers = kwyt_releasers
    release_subscribers = kwyt_subscribers
