# -*- coding: utf-8 -*-

import datetime

from sandbox import sdk2
import sandbox.common.types.task as ctt

from sandbox.projects.laas.AnonymousIP import AnonymousIpCollectTask


class AnonymousIpReleaseTask(sdk2.Task):
    """
    Download and release AnonymousIP CSV files from MaxMind
    """

    def on_execute(self):
        with self.memoize_stage.create_children:
            task = AnonymousIpCollectTask(
                self,
                description='AnonymousIP CSV files from MaxMind',
                notifications=self.Parameters.notifications,
                create_sub_task=False,
            )

            task.enqueue()

            self.Context.task_id = task.id
            self.Context.task_description = task.Parameters.description

            raise sdk2.WaitTask([task.id], ctt.Status.Group.SUCCEED, wait_all=True)

        self.server.release(
            task_id=self.Context.task_id,
            type=ctt.ReleaseStatus.STABLE,
            subject=self.Context.task_description + " " + str(datetime.datetime.now())
        )
