import sys
import argparse


def parse_args():
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument('-g', '--geodata',
                        default="geodata.bin",
                        help="path to geodata")
    args = parser.parse_args()
    return args


def main(args):
    import geobase6

    lookup = geobase6.Lookup(args.geodata)
    ips = ["91.185.67.225", "91.185.67.225", "8.8.8.8", "212.19.2.1"]
    regions = [1, 2, 213, 10000, 76]
    for ip in ips:
        lookup.get_ip_traits(ip)
        lookup.is_tor_ip(ip)
        lookup.get_regions_path(ip)
        lookup.get_region_id_by_ip(ip)

    for region_id in regions:
        lookup.get_country_id(region_id)
        lookup.get_region_by_id(region_id)
        lookup.get_region_type(region_id)
        lookup.get_tree(region_id)

    lookup.get_region_id_by_location(50, 60, True)

    return 0


if __name__ == "__main__":
    sys.exit(main(parse_args()))
