# coding=utf-8
from sandbox.common.mds.compression.base import CompressionType
from sandbox.common.types import resource as ctr
from sandbox.sdk2 import Resource


class LavkaFrontendProjectBuild(Resource):
    """
    Ready for deploy project build
    """
    any_arch = True
    auto_backup = True
    releasable = True
    restart_policy = ctr.RestartPolicy.IGNORE
    pack_tar = CompressionType.TGZ


class LavkaFrontendNpmCache(Resource):
    """
    Distributed npm cache for taxi/lavka/frontend
    """
    any_arch = True
    auto_backup = True
    releasable = True
    restart_policy = ctr.RestartPolicy.IGNORE
    pack_tar = CompressionType.TGZ


class LavkaFrontendNodejsBinaries(Resource):
    """
    Ready for use nodejs binaries
    """
    any_arch = True
    auto_backup = True
    releasable = True
    restart_policy = ctr.RestartPolicy.IGNORE
    pack_tar = CompressionType.TGZ
