# coding: utf-8

from sandbox import sdk2

RELEASERS = [
    'LBS'
]


class LBS_BINBASE_GSM(sdk2.Resource):
    """
        GSM binary base for LBS; gzipped.
    """
    releasable = True
    releasers = RELEASERS


class LBS_BINBASE_WIFI(sdk2.Resource):
    """
        WIFI binary base for LBS; gzipped.
    """
    releasable = True
    releasers = RELEASERS


class PORTO_LAYER_LBS(sdk2.Resource):
    """
        Образ porto контейнера для проекта LBS
    """
    releasable = True
    releasers = RELEASERS


class LBS_SERVER_EXECUTABLE(sdk2.Resource):
    """
        Executable LBS server.
    """
    executable = True
    releasable = True
    releasers = RELEASERS


class LBS_INDOOR_SERVER_EXECUTABLE(sdk2.Resource):
    """
        Executable LBS indoor server.
    """
    executable = True
    releasable = True
    releasers = RELEASERS


class LBS_INDOOR_STATIC_DATA(sdk2.Resource):
    """
        Static data for LBS indoor server.
    """
    releasable = True
    releasers = RELEASERS


class LBS_VIEWER_EXECUTABLE(sdk2.Resource):
    """
        Executable LBS viewer.
    """
    executable = True
    releasable = True
    releasers = RELEASERS
