# coding: utf-8

import logging
import sandbox.projects.lemur as lemur_resources

from sandbox.sandboxsdk import sandboxapi
from sandbox.sandboxsdk import parameters
from sandbox.projects.lemur.common.base_bin_build import BaseBuildLemurBins
from sandbox.projects.lemur.common.base_bin_build import LemurBinaries
from sandbox.projects.lemur.common.base_bin_build import init


class BuildLemurExternalPackage(BaseBuildLemurBins):
    '''
    External binaries, configs and scripts for Lemur.
    '''

    type = 'BUILD_LEMUR_EXTERNAL_PACKAGE'

    class IncludeSvnConfigs(parameters.SandboxBoolParameter):
        name = 'include_svn_configs'
        description = 'configs'
        default_value = True
        group = 'Lemur External Files'

    class IncludeSvnScripts(parameters.SandboxBoolParameter):
        name = 'include_svn_scripts'
        description = 'scripts'
        default_value = True
        group = 'Lemur External Files'

    class ReleaseToNanny(parameters.SandboxRadioParameter):
        choices = [(_, _) for _ in ('none', sandboxapi.RELEASE_TESTING)]
        description = "Release to Nanny."
        default_value = 'none'
        name = 'release_to_nanny'
        group = 'After Build Actions'

    TARGET_RESOURCES = (
        lemur_resources.LEMUR_CM_FILTER_BUILD,
        lemur_resources.LEMUR_DYNAMIC_URLIFNO_UPDATER,
        lemur_resources.LEMUR_KWGENE,
        lemur_resources.LEMUR_KWFEED,
        lemur_resources.LEMUR_ACTUALIZE_KIWI_EXPORT,
        lemur_resources.LEMUR_SR_CONDUCT_RULES_EXPERIMENT,
        lemur_resources.LEMUR_FUT,
        lemur_resources.LEMUR_ZORACL,
    )

    input_parameters, enabled_builds = init(TARGET_RESOURCES, [LemurBinaries])
    input_parameters = input_parameters + [
                                           IncludeSvnConfigs,
                                           IncludeSvnScripts,
                                           ReleaseToNanny
                                          ]

    def on_execute(self):
        BaseBuildLemurBins.on_execute(self)

        if self.ctx['release_to_nanny'] != 'none':

            check_already_released = False

            releaser_task = self.create_subtask(
                task_type='RELEASE_ANY',
                input_parameters={
                    'check_already_released': check_already_released,
                    'release_task_id': self.id,
                    'release_status': self.ctx['release_to_nanny'],
                },
                description="Lemur binaries (task id: {}) auto release. Revision: {}".format(str(self.id), self.ctx.get('arcadia_revision'))
            )
            logging.debug("Subtask {} runned, waiting for it's result.\n\n".format(releaser_task.id))

    def post_build(self, source_dir, output_dir, pack_dir):
        BaseBuildLemurBins.post_build(self, source_dir, output_dir, pack_dir)

        if self.ctx['include_svn_configs']:
            self._create_svn_resource({
            }, 'svn_configs.tar.gz', lemur_resources.LEMUR_EXTERNAL_SVN_CONFIGS, source_dir)

__Task__ = BuildLemurExternalPackage
