# coding: utf-8

import logging
import sandbox.projects.lemur as lemur_resources

from sandbox import sdk2
from sandbox.sandboxsdk import sandboxapi
from sandbox.sandboxsdk import parameters
from sandbox.projects.lemur.common.base_bin_build import BaseBuildLemurBins
from sandbox.projects.lemur.common.base_bin_build import LemurBinaries
from sandbox.projects.lemur.common.base_bin_build import init


class BuildLemurPackage(BaseBuildLemurBins):
    '''
    Binaries, configs and scripts for Lemur.
    '''

    type = 'BUILD_LEMUR_PACKAGE'
    execution_space = 60 * 1024

    class Requirements(sdk2.Task.Requirements):
        disk_space = 60 * 1024

    class IncludeSvnConfigs(parameters.SandboxBoolParameter):
        name = 'include_svn_configs'
        description = 'configs'
        default_value = True
        group = 'Lemur Files'

    class IncludeSvnScripts(parameters.SandboxBoolParameter):
        name = 'include_svn_scripts'
        description = 'scripts'
        default_value = True
        group = 'Lemur Files'

    class IncludeCrawlView(parameters.SandboxBoolParameter):
        name = 'crawlviewer'
        description = 'crawlviewer'
        default_value = True

    class IncludeStgviewer(parameters.SandboxBoolParameter):
        name = 'stgviewer'
        description = 'stgviewer'
        default_value = True

    class ReleaseToNanny(parameters.SandboxRadioParameter):
        choices = [(_, _) for _ in ('none', sandboxapi.RELEASE_TESTING)]
        description = "Release to Nanny."
        default_value = 'none'
        name = 'release_to_nanny'
        group = 'After Build Actions'

    TARGET_RESOURCES = (
        lemur_resources.LEMUR_VINTAGE,
        lemur_resources.LEMUR_EXPORTPROCESSOR,
        lemur_resources.LEMUR_FACTORSPROCESSOR,
        lemur_resources.LEMUR_PREPARATPROCESSOR,
        lemur_resources.LEMUR_SENDLINKPROCESSOR,
        lemur_resources.LEMUR_QUEUEPROCESSOR,
        lemur_resources.LEMUR_PREPARE_GEMINI,
        lemur_resources.LEMUR_PREPARE_OWNER_DATA,
        lemur_resources.LEMUR_UPLOAD_CANONIZATION_DATA,
        lemur_resources.LEMUR_UPLOAD_RENEWED_DATA,
        lemur_resources.LEMUR_SPLIT_RENEWED_DATA,
        lemur_resources.LEMUR_COUNTERS_TOOL,
        lemur_resources.LEMUR_STAGE_DURATIONS,
        lemur_resources.LEMUR_DEPLETED_QUEUES,
        lemur_resources.LEMUR_MASSREDIR_MERGER,
        lemur_resources.LEMUR_WEBMASTER_DATA,
        lemur_resources.LEMUR_UPDATE_LEMUR_URL_DATA,
        lemur_resources.LEMUR_SEND_OVS_HOST_STATS_TO_SOLOMON,
        lemur_resources.LEMUR_HARVESTER,
        lemur_resources.LEMUR_UZOR_RESPONSE_PROCESSOR,
        lemur_resources.LEMUR_LEMURWORM,
        lemur_resources.LEMUR_USERDATA_PARSER,
        lemur_resources.LEMUR_HISTOVIEWER,
        lemur_resources.LEMUR_GOOGLEAPI_KEY_CHECKER,
        lemur_resources.LEMUR_PROCESS_LOGS_NEW,
        lemur_resources.LEMUR_SALMON_AGENT,
        lemur_resources.LEMUR_COUNT_CANDIDATES_TOP,
        lemur_resources.LEMUR_PRINTHISTORECS,
        lemur_resources.LEMUR_EXTRACT_TEST_DATA,
        lemur_resources.LEMUR_STG_NOTIFIER,
        lemur_resources.LEMUR_LIMITS_TESTER,
        lemur_resources.LEMUR_HISTO_DB_UPDATER,
        lemur_resources.LEMUR_USERDATA_FACTORS,

# ban detector
        lemur_resources.LEMUR_BAN_DETECTOR_EXPORTER,
        lemur_resources.LEMUR_BAN_DETECTOR_MERGER,
        lemur_resources.LEMUR_BAN_DETECTOR_POSTMAN,
        lemur_resources.LEMUR_BAN_DETECTOR_FHH_TOOL,
        lemur_resources.LEMUR_BAN_DETECTOR_CHECKER,
        lemur_resources.LEMUR_BAN_DETECTOR_ZORA_HOSTS,


# quality
        lemur_resources.LEMUR_HOST_SAMPLE_LIMITER,
        lemur_resources.LEMUR_FACTORS_HANDLER,
        lemur_resources.LEMUR_ACTUALIZE_KIWI_EXPORT_MERGER,
        lemur_resources.LEMUR_RANKS_STAT,
        lemur_resources.LEMUR_NIRVANA_GRAPH_STARTER,
        lemur_resources.LEMUR_SRTOOL,
        lemur_resources.LEMUR_UNPACK_HOSTDATA,
        lemur_resources.LEMUR_ARRANGE_SAMPLES,
        lemur_resources.LEMUR_UNPACK_SAMPLES,
        lemur_resources.LEMUR_CALCQUALITY,
        lemur_resources.LEMUR_COMPILESLICES_MR,
        lemur_resources.LEMUR_ARRANGE_CRAWLATTEMPT_LOGS,
        lemur_resources.LEMUR_CRAWL_METRICS,
        lemur_resources.LEMUR_POLICY_METRIC,
        lemur_resources.LEMUR_DYNAMIC_URLIFNO_UPDATER,
        lemur_resources.LEMUR_SELECTIONRANK_EXPERIMENT,
    )

    input_parameters, enabled_builds = init(TARGET_RESOURCES, [LemurBinaries])
    input_parameters = input_parameters + [
                                           IncludeCrawlView,
                                           IncludeStgviewer,
                                           IncludeSvnConfigs,
                                           IncludeSvnScripts,
                                           ReleaseToNanny
                                          ]

    def on_execute(self):
        BaseBuildLemurBins.on_execute(self)

        if self.ctx['release_to_nanny'] != 'none':

            check_already_released = False

            releaser_task = self.create_subtask(
                task_type='RELEASE_ANY',
                input_parameters={
                    'check_already_released': check_already_released,
                    'release_task_id': self.id,
                    'release_status': self.ctx['release_to_nanny'],
                },
                description="Lemur binaries (task id: {}) auto release. Revision: {}".format(str(self.id), self.ctx.get('arcadia_revision'))
            )
            logging.debug("Subtask {} runned, waiting for it's result.\n\n".format(releaser_task.id))

    def post_build(self, source_dir, output_dir, pack_dir):
        BaseBuildLemurBins.post_build(self, source_dir, output_dir, pack_dir)

        if self.ctx['include_svn_configs']:
            self._create_svn_resource({
                'robot/lemur/conf': '',
                'yweb/robot/ukrop/conf': 'ukrop',
                'robot/lemur/mnformulas': '',
                'robot/samovar/conf': 'samovar',
            }, 'svn_configs.tar.gz', lemur_resources.LEMUR_SVN_CONFIGS, source_dir)

        if self.ctx['include_svn_scripts']:
            self._create_svn_resource({
                'robot/lemur/scripts': '',
                'yweb/robot/ukrop/scripts': 'ukrop'
            }, 'scripts.tar.gz', lemur_resources.LEMUR_SVN_SCRIPTS, source_dir)

        if self.ctx['stgviewer']:
            self._create_svn_resource({
                'robot/lemur/stgviewer': '',
            }, 'stgviewer.tar.gz', lemur_resources.LEMUR_STGVIEWER_FILES, source_dir)

        if self.ctx['crawlviewer']:
            self._create_svn_resource({
                    'yweb/robot/analitics/crawlview': ''
            }, 'crawlview.tar.gz', lemur_resources.LEMUR_CRAWLVIEW_FILES, source_dir)


__Task__ = BuildLemurPackage
