# coding: utf-8

import sandbox.projects.lemur as lemur_resources

from sandbox import sdk2
from sandbox.sandboxsdk import parameters
from sandbox.projects.lemur.common.base_bin_build import BaseBuildLemurBins
from sandbox.projects.lemur.common.base_bin_build import LemurBinaries
from sandbox.projects.lemur.common.base_bin_build import init


class BuildLemurUzorPackage(BaseBuildLemurBins):
    '''
    Binaries and configs for lemur's uzor.
    '''

    type = 'BUILD_LEMUR_UZOR_PACKAGE'

    class Requirements(sdk2.Task.Requirements):
        disk_space = 40 * 1024

    class UkropConfigs(parameters.SandboxBoolParameter):
        name = 'include_svn_ukrop_configs'
        description = 'ukrop configs'
        default_value = True
        group = 'Ukrop configs'

    class UzorConfigs(parameters.SandboxBoolParameter):
        name = 'include_svn_uzor_configs'
        description = 'uzor configs'
        default_value = True
        group = 'Lemur uzor configs'

    TARGET_RESOURCES = (
            lemur_resources.LEMUR_UZOR,
    )

    input_parameters, enabled_builds = init(TARGET_RESOURCES, [LemurBinaries])
    input_parameters = input_parameters + [UkropConfigs, UzorConfigs]

    def post_build(self, source_dir, output_dir, pack_dir):
        BaseBuildLemurBins.post_build(self, source_dir, output_dir, pack_dir)

        if self.ctx['include_svn_ukrop_configs']:
            self._create_svn_resource({'robot/lemur/conf': 'lemur',
                                       'yweb/robot/ukrop/conf': 'ukrop'}, 'svn_configs.tar.gz', lemur_resources.LEMUR_SVN_CONFIGS, source_dir)

        if self.ctx['include_svn_uzor_configs']:
            self._create_svn_resource({'robot/uzor/conf': ''}, 'svn_uzor_configs.tar.gz', lemur_resources.LEMUR_UZOR_SVN_CONFIGS, source_dir)


__Task__ = BuildLemurUzorPackage
