# coding: utf-8

import sandbox.projects.lemur as lemur_resources

from sandbox import sdk2
from sandbox.sandboxsdk import parameters
from sandbox.projects.lemur.common.base_bin_build import BaseBuildLemurBins
from sandbox.projects.lemur.common.base_bin_build import LemurBinaries
from sandbox.projects.lemur.common.base_bin_build import init
from sandbox.common.types.task import ReleaseStatus

import logging
import time

class RestartLemurUzorService(BaseBuildLemurBins):
    '''
    Task for lemur_uzor service restrart
    '''

    type = 'RESTART_LEMUR_UZOR_SERVICE'

    input_parameters, enabled_builds = init(tuple(), [])

    def on_execute(self):
        BaseBuildLemurBins.on_execute(self)

        check_already_released = False

        releaser_task = self.create_subtask(
            task_type='RELEASE_ANY',
            input_parameters={
                'check_already_released': check_already_released,
                'release_task_id': self.id,
                'release_status': 'stable',
            },
            description="Lemur uzor restart (task id: {})".format(str(self.id))
        )
        logging.debug("Subtask {} runned, waiting for it's result.\n\n".format(releaser_task.id))

    def post_build(self, source_dir, output_dir, pack_dir):
        BaseBuildLemurBins.post_build(self, source_dir, output_dir, pack_dir)

        self._create_svn_resource({'robot/uzor/conf/conf-lemur-prod/empty': ''}, 'useless.tar.gz', lemur_resources.LEMUR_UZOR_RESTART_RESOURCE, source_dir)


__Task__ = RestartLemurUzorService
