# coding: utf-8

from sandbox import sdk2
from sandbox.sdk2.resource import AbstractResource
from sandbox.projects.resource_types import releasers as resource_releasers

# utility


class PORTO_LAYER_LEMUR_CM(sdk2.resource.AbstractResource):
    """
    Porto layer for Lemur CM
    """
    releasable = True
    releasers = resource_releasers.samovar_releasers


class PORTO_LAYER_LEMUR_CRAWLVIEW(sdk2.resource.AbstractResource):
    """
    Porto layer for Lemur Crawlview
    """
    releasable = True
    releasers = resource_releasers.samovar_releasers


class LEMUR_SYMBOLS_ARCHIVE(AbstractResource):
    """
        Symbols from lemur binaries
    """
    releasable = True
    executable = False
    any_arch = False
    releasers = resource_releasers.samovar_releasers


class LEMUR_BINARY_BASE(AbstractResource):
    """
        Base class for binary files used in Lemur Project.
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = resource_releasers.samovar_releasers


# SVN checkout

class LEMUR_SVN_CONFIGS(AbstractResource):
    """
        Class for Lemur configs from svn
    """
    releasable = True
    executable = False
    releasers = resource_releasers.samovar_releasers


class LEMUR_ZORA_CONFIGS(AbstractResource):
    """
        Class for ZORA configs from svn
    """
    releasable = True
    executable = False
    releasers = resource_releasers.samovar_releasers


class LEMUR_EXTERNAL_SVN_CONFIGS(AbstractResource):
    """
        Class for external Lemur configs from svn
    """
    releasable = True
    executable = False
    releasers = resource_releasers.samovar_releasers


class LEMUR_SVN_SCRIPTS(LEMUR_SVN_CONFIGS):
    """
        Class for Lemur scripts from svn
    """
    pass


class LEMUR_EXTERNAL_DATA(LEMUR_SVN_CONFIGS):
    """
        Class for Samovar external data
    """
    releasers = resource_releasers.samovar_releasers + ['robot-samovar']


class LEMUR_CRAWLVIEW_FILES(AbstractResource):
    """
        Class for Crawlview files
    """
    releasable = True
    executable = False
    releasers = resource_releasers.samovar_releasers


class LEMUR_STGVIEWER_FILES(AbstractResource):
    """
        Class for Crawlview files
    """
    releasable = True
    executable = False
    releasers = resource_releasers.samovar_releasers


# Lemur binaries (for BUILD_LEMUR_PACKAGE)


class LEMUR_LEMURWORM(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/lemurworm/lemurworm'


class LEMUR_VINTAGE(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/vintage/main/vintage'


class LEMUR_HARVESTER(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/harvester/main/harvester'


class LEMUR_KIWIEXPORTPROCESSOR(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/kiwiexportprocessor/main/kiwiexportprocessor'


class LEMUR_UZOR_RESPONSE_PROCESSOR(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/uzor_response_processor/uzor_response_processor'


class LEMUR_COUNTERS_TOOL(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/counters_tool/counters_tool'


class LEMUR_SEND_OVS_HOST_STATS_TO_SOLOMON(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/send_ovs_host_stats_to_solomon/send_ovs_host_stats_to_solomon'


class LEMUR_GOOGLEAPI_KEY_CHECKER(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/googleapi_key_checker/googleapi_key_checker'


class LEMUR_BANNED_CHECKER(LEMUR_BINARY_BASE):
    # unused
    arcadia_build_path = 'robot/lemur/tools/banned_checker/banned_checker'


class LEMUR_BANNED_MERGER(LEMUR_BINARY_BASE):
    # unused
    arcadia_build_path = 'robot/lemur/tools/banned_merger/banned_merger'


class LEMUR_UA_TO_CONFIG_TOOL(LEMUR_BINARY_BASE):
    # unused
    arcadia_build_path = 'robot/lemur/tools/ua_to_config_tool/ua_to_config_tool'


class LEMUR_BANS_UPDATER(LEMUR_BINARY_BASE):
    # unused
    arcadia_build_path = 'robot/lemur/tools/bans_updater/bans_updater'


class LEMUR_BANS_POSTMAN(LEMUR_BINARY_BASE):
    # unused
    arcadia_build_path = 'robot/lemur/tools/bans_postman/bans_postman'


class LEMUR_UPDATE_BAN_STATUS(LEMUR_BINARY_BASE):
    # unused
    arcadia_build_path = 'robot/lemur/tools/update_ban_status/update_ban_status'


class LEMUR_EXPORTPROCESSOR(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/exportprocessor/main/exportprocessor'


class LEMUR_FACTORSPROCESSOR(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/factorsprocessor/main/factorsprocessor'


class LEMUR_MASSREDIR_MERGER(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/massredir_merger/massredir_merger'


class LEMUR_PREPARATPROCESSOR(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/preparatprocessor/main/preparatprocessor'


class LEMUR_PREPARE_GEMINI(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/prepare_gemini/prepare_gemini'


class LEMUR_PREPARE_OWNER_DATA(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/prepare_owner_data/prepare_owner_data'


class LEMUR_REDIRECTPROCESSOR(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/redirectprocessor/main/redirectprocessor'


class LEMUR_SENDLINKPROCESSOR(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/sendlinkprocessor/main/sendlinkprocessor'


class LEMUR_UPLOAD_CANONIZATION_DATA(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/upload_canonization_data/upload_canonization_data'


class LEMUR_UPLOAD_RENEWED_DATA(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/upload_renewed_data/upload_renewed_data'


class LEMUR_QUEUEPROCESSOR(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/queueprocessor/main/queueprocessor'


class LEMUR_WEBMASTER_DATA(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/external_sources/webmaster-data/webmaster-data'


class LEMUR_SPLIT_RENEWED_DATA(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/split_renewed_data/split_renewed_data'


class LEMUR_UPDATE_LEMUR_URL_DATA(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/update_lemur_url_data/update_lemur_url_data'


class LEMUR_USERDATA_PARSER(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/userdata/parser/userdataparser'


class LEMUR_HISTOVIEWER(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/histoviewer/histoviewer'


class LEMUR_PROCESS_LOGS_NEW(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/process_logs_new/process_logs_new'


class LEMUR_PRINTHISTORECS(LEMUR_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/ukrop/tools/printhistorecs/printhistorecs'


class LEMUR_SALMON_AGENT(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/monitoring/salmon_agent/salmon_agent'


class LEMUR_DEPLETED_QUEUES(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/depleted_queues/depleted_queues'


class LEMUR_STAGE_DURATIONS(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/stage_durations/stage_durations'


class LEMUR_COUNT_CANDIDATES_TOP(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/count_candidates_top/count_candidates_top'


class LEMUR_EXTRACT_TEST_DATA(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/extract_test_data/extract_test_data'


class LEMUR_STG_NOTIFIER(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/stg_notifier/stg_notifier'


class LEMUR_OUTLINKS_BLOOMFILTER(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/outlinks_bloomfilter/calculate/calculate_outlinks_bloomfilter'


class LEMUR_LIMITS_TESTER(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/samovar/tools/limits_tester/limits_tester'


class LEMUR_HISTO_DB_UPDATER(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/histo_db_updater/histo_db_updater'


class LEMUR_USERDATA_FACTORS(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/quality/userdata_factors/userdata_factors'


# Ban detector

class LEMUR_BAN_DETECTOR_EXPORTER(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/ban_detector/exporter/exporter'

class LEMUR_BAN_DETECTOR_MERGER(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/ban_detector/merger/merger'

class LEMUR_BAN_DETECTOR_POSTMAN(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/ban_detector/postman/postman'

class LEMUR_BAN_DETECTOR_FHH_TOOL(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/ban_detector/forced_host_headers_tool/forced_host_headers_tool'

class LEMUR_BAN_DETECTOR_CHECKER(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/ban_detector/checker/checker'

class LEMUR_BAN_DETECTOR_ZORA_HOSTS(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/ban_detector/zora_hosts/zora_hosts'

# Quality

class LEMUR_HOST_SAMPLE_LIMITER(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/host_sample_limiter/host_sample_limiter'


class LEMUR_FACTORS_HANDLER(LEMUR_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/ukrop/tools/factors_handler/factors_handler'


class LEMUR_ACTUALIZE_KIWI_EXPORT_MERGER(LEMUR_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/ukrop/tools/actualize_kiwi_export_merger/actualize_kiwi_export_merger'


class LEMUR_RANKS_STAT(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/ranks_stat/ranks_stat'


class LEMUR_NIRVANA_GRAPH_STARTER(LEMUR_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/ukrop/nirvana_tools/graph_starter/graph-starter'


class LEMUR_SRTOOL(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/selectionrank/srtool/srtool'


class LEMUR_UNPACK_HOSTDATA(LEMUR_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/ukrop/tools/unpack_hostdata/unpack_hostdata'


class LEMUR_ARRANGE_SAMPLES(LEMUR_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/ukrop/tools/arrange_samples/arrange_samples'


class LEMUR_UNPACK_SAMPLES(LEMUR_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/ukrop/tools/unpack_samples/unpack_samples'


class LEMUR_CALCQUALITY(LEMUR_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/ukrop/hostslices/calcquality/calcquality'


class LEMUR_COMPILESLICES_MR(LEMUR_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/ukrop/hostslices/compileslices_mr/compileslices_mr'


class LEMUR_ARRANGE_CRAWLATTEMPT_LOGS(LEMUR_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/ukrop/tools/arrange_crawlattempt_logs/arrange_crawlattempt_logs'


class LEMUR_CRAWL_METRICS(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/lemur/tools/crawl_metrics/main/crawl_metrics'


class LEMUR_POLICY_METRIC(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/metrics/policy_metric/policy_metric'


# Lemur external binaries (for BUILD_LEMUR_EXTERNAL_PACKAGE)


class LEMUR_CM_FILTER_BUILD(LEMUR_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/tools/filter_build/filter_build'


class LEMUR_GEMINICL(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/gemini/client2/geminicl'


class LEMUR_PREPARE_REGEX_TEST_DATA(LEMUR_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/ukrop/hostslices/prepare_regex_test_data/prepare_regex_test_data'


class LEMUR_DYNAMIC_URLIFNO_UPDATER(LEMUR_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/metrics/pmusca/update_lemur_urlinfo/bin/update_lemur_urlinfo'


class LEMUR_KWGENE(LEMUR_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/kiwi/kwgene/kwgene'


class LEMUR_KWFEED(LEMUR_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/kiwi/kwfeed/kwfeed'


class LEMUR_ACTUALIZE_KIWI_EXPORT(LEMUR_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/gefest/actualize_kiwi_export/actualize_kiwi_export'


class LEMUR_SR_CONDUCT_RULES_EXPERIMENT(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/selectionrank/sr_conduct_rules_experiment/sr_conduct_rules_experiment'


class LEMUR_FUT(LEMUR_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/fut/fut'


class LEMUR_ZORACL(LEMUR_BINARY_BASE):
    arcadia_build_path = 'zora/client/main/zoracl'


class LEMUR_SELECTIONRANK_EXPERIMENT(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/selectionrank/tools/experiment/selectionrank_experiment'


# Uzor

class LEMUR_UZOR(LEMUR_BINARY_BASE):
    arcadia_build_path = 'robot/uzor/bin/uzor'

class LEMUR_UZOR_RESTART_RESOURCE(AbstractResource):
    """
        Stub resource for service restart
    """
    releasable = True
    executable = False
    releasers = resource_releasers.samovar_releasers

class LEMUR_UZOR_SVN_CONFIGS(AbstractResource):
    """
        Class for Lemur configs from svn
    """
    releasable = True
    executable = False
    releasers = resource_releasers.samovar_releasers

