# coding: utf-8

from sandbox.sdk2.resource import AbstractResource
from sandbox.projects.resource_types import releasers as resource_releasers

# utility


class LIMBO_BINARY_BASE(AbstractResource):
    """
        Base class for binary files used in Limbo.
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = resource_releasers.samovar_releasers


# SVN checkout

class LIMBO_SVN_CONFIGS(AbstractResource):
    """
        Class for Limbo configs from svn
    """
    releasable = True
    executable = False
    releasers = resource_releasers.samovar_releasers


class LIMBO_SVN_SCRIPTS(LIMBO_SVN_CONFIGS):
    """
        Class for Limbo scripts from svn
    """
    pass

# Limbo binaries (for BUILD_LIMBO_PACKAGE)


class LIMBO_LIMBO(LIMBO_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/limbo/limbo-2'


class LIMBO_SAMOVAR_PREPARE_IMAGES_FACES_PUSHES(LIMBO_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/limbo_tools/samovar_prepare_images_faces_pushes/samovar_prepare_images_faces_pushes'

class LIMBO_SAMOVAR_PARSE_SEARCH_LOG_IMAGES(LIMBO_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/limbo_tools/samovar_parse_search_log_images/samovar_parse_search_log_images'

class LIMBO_SAMOVAR_PREPARE_USERDATA(LIMBO_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/limbo_tools/samovar_prepare_userdata/samovar_prepare_userdata'

class LIMBO_SAMOVAR_PREPARE_UBLP(LIMBO_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/limbo_tools/samovar_prepare_ublp/samovar_prepare_ublp'

class LIMBO_SAMOVAR_WATCH_LOG_MANAGER(LIMBO_BINARY_BASE):
    arcadia_build_path = 'yweb/robot/limbo_tools/samovar_watch_log_manager/samovar_watch_log_manager'


class LIMBO_ZORACL(LIMBO_BINARY_BASE):
    arcadia_build_path = 'zora/client/main/zoracl'
