# -*- coding: utf-8 -*-
from sandbox import sdk2


releasers = [
    'artgromov',
    'alexnick',
    'komels',
    'gusev-p',
    'alexbogo',
    'whcrc',
    'robot-logbroker-ci',
    'aleksei-le',
]


# unified agent resources
class UnifiedAgentBin(sdk2.Resource):
    releasable = True
    releasers = releasers
    executable = True
    auto_backup = True
    build_task_id = sdk2.parameters.Integer("Build task id")
    unified_agent_version = sdk2.parameters.String('Unified Agent version')


class UnifiedAgentWindowsBin(sdk2.Resource):
    releaseable = True
    releasers = releasers
    executable = True
    auto_backup = True
    build_task_id = sdk2.parameters.Integer("Build task id")
    unified_agent_version = sdk2.parameters.String('Unified Agent version')


class UnifiedAgentDebugSymbols(sdk2.Resource):
    releasable = True
    releasers = releasers
    auto_backup = True
    build_task_id = sdk2.parameters.Integer("Build task id")
    unified_agent_version = sdk2.parameters.String('Unified Agent version')


class UnifiedAgentJugglerBundle(sdk2.Resource):
    releasable = True
    releasers = releasers
    executable = True
    auto_backup = True


class UnifiedAgentConsistencyTestBin(sdk2.Resource):
    releasable = True
    releasers = releasers
    executable = True
    auto_backup = True


class UnifiedAgentYtCompareTestBin(sdk2.Resource):
    releasable = True
    releasers = releasers
    any_arch = True
    executable = True
    auto_backup = True


class LogbrokerJugglerBundle(sdk2.Resource):
    releasable = True
    releasers = releasers
    executable = True
    auto_backup = True


# deploy resources
class LogbrokerToolsPortoLayer(sdk2.Resource):
    """
    Porto layer for logbroker_tools_box rootfs in Y.Deploy.
    """
    releasable = True
    releasers = releasers
    auto_backup = True
    build_task_id = sdk2.parameters.Integer("Build task id")
    unified_agent_version = sdk2.parameters.String('Unified Agent version')
    released_sas_test = sdk2.parameters.Bool("Released on Y.Deploy cluster sas_test", default_value=False)
    released_man_pre = sdk2.parameters.Bool("Released on Y.Deploy cluster man_pre", default_value=False)
    released_xdc_acceptance = sdk2.parameters.Bool("Released on Y.Deploy cluster xdc acceptance", default_value=False)
    released_xdc = sdk2.parameters.Bool("Released on Y.Deploy cluster xdc", default_value=False)
    sync_upload_to_mds = True


class LogbrokerToolsBin(sdk2.Resource):
    """
    Binary with hooks and tools in LogbrokerToolsPortoLayer.
    """
    releasable = True
    releasers = releasers
    auto_backup = True


class LogbrokerJugglerDeployChecksGenerator(sdk2.Resource):
    releasable = True
    releasers = releasers
    auto_backup = True


class DeployConsistencyTestBin(sdk2.Resource):
    releasable = True
    releasers = releasers
    executable = True
    auto_backup = True


class DeployRestrictionTestBin(sdk2.Resource):
    releasable = True
    releasers = releasers
    executable = True
    auto_backup = True


# other resources
class LogbrokerJugglerStatsBinary(sdk2.Resource):
    releasable = True
    releasers = releasers
    executable = True
    auto_backup = True


class LogbrokerJugglerHelperBinary(sdk2.Resource):
    releasable = True
    releasers = releasers
    auto_backup = True


class AnsibleLib(sdk2.Resource):
    releasable = False
    auto_backup = True


class AnsibleBin(sdk2.Resource):
    releasable = True
    releasers = ['artgromov']
    auto_backup = True


class LogbrokerTestData(sdk2.Resource):
    releasable = False
    auto_backup = True


class YtsenderBin(sdk2.Resource):
    releasable = True
    releasers = releasers
    auto_backup = True
    build_task_id = sdk2.parameters.Integer("Build task id")


class LegacyReadDataInfoBinary(sdk2.Resource):
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True


class LegacyWriteDataInfoBinary(sdk2.Resource):
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True


class GRPCWriteDataInfoBinary(sdk2.Resource):
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True


class RetentionTimeInfoBinary(sdk2.Resource):
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
