import os

from shutil import copyfile
from sandbox import sdk2
from sandbox.projects import resource_types
from sandbox.projects.common.build.YaMake2 import YaMake2


class BuildSeveralResources(YaMake2):
    class Parameters(YaMake2.Parameters):
        with sdk2.parameters.Group('Save additional resources') as save_additional_resources_group:
            additional_resources_path = sdk2.parameters.List('Additional resources path (path or RESOURCE_TYPE:path)')
            additional_resources_default_type = sdk2.parameters.String('Default resources type', default=resource_types.ARCADIA_PROJECT.name)
            additional_resources_ttl = sdk2.parameters.Integer('TTL in days', default=30)

    def post_build(self, source_dir, output_dir, pack_dir):
        additional_resources_path = 'additional_resources'
        os.mkdir(additional_resources_path)
        for path in self.Parameters.additional_resources_path:
            resource_type_name = self.Parameters.additional_resources_default_type
            if ':' in path:
                resource_type_name, path = path.split(':')
            resource_path = os.path.join(additional_resources_path, os.path.basename(path))
            copyfile(os.path.join(output_dir, path), resource_path)
            resource_cls = sdk2.Resource[resource_type_name]
            resource = resource_cls(self, 'additional resource: {}\n{}'.format(path, self.Parameters.description), resource_path, ttl=self.Parameters.additional_resources_ttl)
            resource_data = sdk2.ResourceData(resource)
