from sandbox import sdk2


############################################################################


class LogFellerAccountSnapshot(sdk2.Task):


    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group("YT token") as yt_token_parameters_block:
            yt_token_vault_owner = sdk2.parameters.String(
                "YT tokent vault owner",
                default=None,
            )

            yt_token_vault_name = sdk2.parameters.String(
                "YT tokent vault name",
                required=True,
            )

        with sdk2.parameters.Group("Task parameters") as task_parameters_block:
            cluster = sdk2.parameters.String(
                "YT cluster to build a snapshot from",
                default="hahn",
                required=True,
                choices=(("hahn", "hahn"), ("arnold", "arnold"), ("hume", "hume"), ("freud", "freud"), ("bohr", "bohr"), ("landau", "landau"))
            )

            destination_cluster = sdk2.parameters.String(
                "YT cluster to write a snapshot on",
                default="hahn",
                required=True,
                choices=(("hahn", "hahn"), ("arnold", "arnold"), ("hume", "hume"), ("freud", "freud"), ("bohr", "bohr"), ("landau", "landau"))
            )

        with sdk2.parameters.Group("Binary resource") as binary_resource_block:
            use_last_binary_resource = sdk2.parameters.Bool(
                "Use last binary resource",
                default=True
            )

            custom_binary_resource = sdk2.parameters.Resource(
                "Use custom binary resource",
                default=None,
            )


    def get_yt_token(self):
        return sdk2.Vault.data(self.Parameters.yt_token_vault_owner, self.Parameters.yt_token_vault_name)


    def on_save(self):
        if self.Parameters.use_last_binary_resource:
            self.Requirements.tasks_resource = sdk2.service_resources.SandboxTasksBinary.find(
                attrs={'target': 'logfeller/LogFellerAccountSnapshot'}
            ).first().id
        else:
            self.Requirements.tasks_resource = self.Parameters.custom_binary_resource


    def on_execute(self):

        from logfeller.analytics.account_snapshot import make_snapshot

        ########################################################################################

        yt_token = self.get_yt_token()

        make_snapshot(self.Parameters.cluster, self.Parameters.destination_cluster, yt_token=yt_token)

############################################################################
