import datetime


class MskTimeZone(datetime.tzinfo):
    def utcoffset(self, dt):
        return datetime.timedelta(hours=3)

    def tzname(self, dt):
        return "Europe/Moscow"

    def dst(selt, dt):
        return datetime.timedelta(0)


class TaskSchedule(object):
    class WorkHours(object):
        def __init__(self, from_hour, to_hour):
            self.from_hour = from_hour
            self.to_hour = to_hour

        def includes(self, hour):
            return self.from_hour <= hour and hour <= self.to_hour

    def __init__(self, week_days=[1, 2, 3, 4, 5], from_hour=10, to_hour=18):
        self.week_days = week_days
        self.hours_interval = TaskSchedule.WorkHours(from_hour, to_hour)

    def avail_now(self):
        now = datetime.datetime.now(MskTimeZone())
        return now.isoweekday() in self.week_days and self.hours_interval.includes(now.hour)
