from sandbox import sdk2
from datetime import datetime, timedelta


############################################################################


class LogfellerAnalyticsLogUsage(sdk2.Task):
    """Logfeller Log Usage Analytics"""

    class Parameters(sdk2.Task.Parameters):
        yt_cluster = sdk2.parameters.String(
            "YT cluster",
            default="hahn",
            required=True,
            choices=(("hume", "hume"), ("hahn", "hahn"), ("arnold", "arnold"), ("freud", "freud"))
        )

        yt_token_vault_name = sdk2.parameters.String(
            "YT token vault name",
            default="LOGFELLER_YT_TOKEN",
            required=True,
        )

        with sdk2.parameters.Group("Build settings") as build_settings_block:
            use_last_binary = sdk2.parameters.Bool(
                "Use last binary archive",
                default=True
            )

            custom_tasks_archive_resource = sdk2.parameters.Resource(
                "task archive resource",
                default=None,
            )

    ########################################################################################
    # utils

    def get_yt_token(self):
        return sdk2.Vault.data(self.Parameters.yt_token_vault_name)

    def yesterday_date(self):
        return str((datetime.today() - timedelta(days=1)).date())

    def create_yt_client(self, proxy):
        import yt.wrapper as yt
        return yt.YtClient(
            proxy=proxy,
            token=self.get_yt_token()
        )

    ########################################################################################
    # callbacks

    def on_save(self):
        if self.Parameters.use_last_binary:
            self.Requirements.tasks_resource = sdk2.service_resources.SandboxTasksBinary.find(
                attrs={'target': 'logfeller/LogUsage'}
            ).first().id
        else:
            self.Requirements.tasks_resource = self.Parameters.custom_tasks_archive_resource

    def on_execute(self):
        from logfeller.analytics.reports.log_usage import log_usage_workflow

        yt_client = self.create_yt_client(self.Parameters.yt_cluster)
        log_usage_workflow.prepare_log_usage_data(yt_client, self.yesterday_date())
