from sandbox import sdk2

import logging
import enum


class AllowedActions(enum.Enum):
    REPLACE = 0
    ADD = 1
    REMOVE = 2
    COMMIT = 3
    RELEASE = 4


class PermissionsManager(object):
    def _check(self, type):
        raise NotImplementedError()

    def check(self, type):
        return self._check(type)

    def verify(self, type):
        allowed = self.check(type)
        if not allowed:
            raise Exception('You don\'t have permission: {}'.format(type.name))
        return allowed


class AllAllowedPermissionsManager(PermissionsManager):
    def _check(self, type):
        return True


class SandboxPermissionsManager(PermissionsManager):
    def __init__(self, task_owner):
        super(SandboxPermissionsManager, self).__init__()
        self.__vault_name = 'LOGFELLER_PERMISSION_{}'.format(task_owner)
        self.__allowed = set()
        try:
            permissions = sdk2.Vault.data('LOGFELLER', self.__vault_name)
            logging.info('Permissions vault data: {}'.format(permissions))
            for p in permissions.split(','):
                self.__allowed.add(p)
        except Exception as e:
            logging.error('Cannot get permission vault={} error={}'.format(self.__vault_name, e))

    def _check(self, type):
        return type.name in self.__allowed
