from sandbox.projects.logfeller.common.environment import LogFellerEnvironment
from sandbox.projects.logfeller.common.task import LogFellerTask

import commands
import logging
import os

############################################################################


class LogFellerParserTask(LogFellerTask):
    """task which parse logbroker-import-log"""

    def _get_parser_command(self):
        binary_path = LogFellerEnvironment.PARSER_PATH
        options = [
            "--yt-proxy %s" % "hahn.yt.yandex.net",
            "--stream-ident %s" % "other",
            "--stream-log-type %s" % "logbroker-import-log",
            "--chunk-splitter %s" % "line-break",
            "--parser %s" % "tskv-log-with-unixtime",
            "--record-formatter %s" % "yamred_dsv",
            "--input-chain-path %s" % "//home/logfeller/staging-area/other/logbroker-import-log",
            "--output-chain-path %s" % "//home/logfeller/logs/logbroker-import-log/stream/5min",
            "--part-time-period  %d" % 300,
            "--part-close-timeout %d" % 600,
            "--dynamic-allocation"
        ]
        return binary_path + " " + " ".join(options)

    def _prepare_environment(self):
        os.environ["YT_TOKEN"] = self._get_yt_token()
        os.environ["YT_POOL"] = "logfeller_index_streams"
        os.environ["YT_SPEC"] = '{"mapper": {"memory_limit": 2147483648}, "data_size_per_job": 536870912, "job_io": {"table_writer": {"max_row_weight": 134217728}}}'
        os.environ["MR_RUNTIME"] = "YT"
        os.environ["YT_PROXY"] = "hahn.yt.yandex.net"

    def on_execute(self):
        self._prepare_environment()

        logging.info("logfeller parsing start")
        logging.info(commands.getstatusoutput(self._get_parser_command()))

############################################################################
