from sandbox.projects.logfeller.common.deploy import run_release_files_to_yt_task

from sandbox import sandboxsdk
from sandbox import sdk2
import sandbox.common.types.task as ctt

from config import DrugLogsConfig

import logging

############################################################################


class ReleaseDrugLog(sdk2.Task):
    """Add new Ya.Drug log to LogFeller configs and release its to YT cluster"""

    class Parameters(sdk2.Task.Parameters):
        topic_path = sdk2.parameters.String(
            "Topic path",
            required=True
        )

    class Requirements(sdk2.Requirements):
        environments = [sandboxsdk.environments.PipEnvironment('yandex-yt')]
        semaphores = ctt.Semaphores(
            acquires=[ctt.Semaphores.Acquire(name="LOGFELLER_COMMIT_DRUG_LOGS")],
            release=(ctt.Status.Group.BREAK, ctt.Status.Group.FINISH)
        )

    def _get_wait_statuses(self):
        return [ctt.Status.Group.FINISH, ctt.Status.Group.BREAK]

    def _release_configs(self):
        return run_release_files_to_yt_task(
            "arnold",
            self.Parameters.owner,
            "LOGFELLER_YT_TOKEN",
            "drug_logs.json",
            self.Context.committed_revision,
            "auto release Drug logs with revision {}".format(self.Context.committed_revision),
            self
        )

    def _find_release_task(self):
        for child in self.find():
            if child.id == self.Context.release_task_id:
                return child
        return None

    def on_execute(self):
        with self.memoize_stage.commit:
            try:
                self.Context.committed_revision = DrugLogsConfig(self.Parameters.topic_path).commit_new_log()
                logging.info("release LOGFELLER_COMMIT_DRUG_LOGS semaphore")
                sdk2.Requirements.semaphores.release()
            except Exception as e:
                self.Context.committed_revision = None
                raise Exception("failed commit new log for topic {}: {}".format(self.Parameters.topic_path, e.message))

        with self.memoize_stage.release:
            if self.Context.committed_revision:
                self.Context.release_task_id = self._release_configs()
                raise sdk2.WaitTask(self.Context.release_task_id, self._get_wait_statuses(), wait_all=True)

        release_task = self._find_release_task()
        if release_task and release_task.status != ctt.Status.SUCCESS:
            raise Exception("release task {} finished with {} status".format(release_task.id, release_task.status))

############################################################################
