import configs_templates

from sandbox import sdk2

from sandbox.projects.common.arcadia import sdk as arcadiasdk
import sandbox.projects.common.constants as consts

from sandbox.projects.infra.common import get_arcadia

from collections import OrderedDict
import json
import logging
import os
import re

############################################################################


class DrugLogsConfig(object):
    ARCADIA_CONFIGS_PATH = "arcadia:/arc/trunk/arcadia/logfeller/configs"

    def __init__(self, topic_path):
        self.topic_path = topic_path
        self._checkout_configs()

    def _checkout_configs(self):
        logging.debug("start checkout")
        self.source_root_path = get_arcadia(sdk2.svn.Arcadia.trunk_url())
        self.configs_local_path = os.path.join(self.source_root_path, "logfeller/configs")
        if os.path.exists(self.configs_local_path):
            logging.debug("ls logfeller/configs: {}".format(os.listdir(self.configs_local_path)))
        else:
            logging.debug("need update")
            self._update_configs()

    def _update_configs():
        pass

    def _get_streams_config_name(self):
        return "deploy_arnold_streams.json"

    def _get_logs_config_name(self):
        return "deploy_arnold_logs.json"

    def _get_streams_config_path(self):
        config_file_name = self._get_streams_config_name()
        return os.path.join(self.configs_local_path, "logs", config_file_name)

    def _get_logs_config_path(self):
        config_file_name = self._get_logs_config_name()
        return os.path.join(self.configs_local_path, "logs", config_file_name)

    def _load_config(self, config_path):
        with open(config_path, "r") as f:
            file_content = f.read()
        return json.loads(file_content)

    def _get_streams_config(self):
        config_file_path = self._get_streams_config_path()
        return self._load_config(config_file_path)

    def _get_logs_config(self):
        config_file_path = self._get_logs_config_path()
        return self._load_config(config_file_path)

    def _dump_config_to_file(self, file_path, config):
        config = OrderedDict(config)
        with open(file_path, "w") as f:
            f.write(json.dumps(config, indent=4, separators=(',', ': ')))

    def _dump_streams_config(self, streams):
        self._dump_config_to_file(
            self._get_streams_config_path(),
            streams
        )

    def _dump_logs_config(self, logs):
        self._dump_config_to_file(
            self._get_logs_config_path(),
            logs
        )

    def _add_stream_config(self):
        streams_config = self._get_streams_config()
        new_stream = self._make_new_stream_config()
        streams_config[new_stream["topic_path"]] = new_stream
        self._dump_streams_config(streams_config)

    def _add_log_config(self):
        logs_config = self._get_logs_config()
        new_log = self._make_new_log_config()
        logs_config[new_log["name"]] = new_log
        self._dump_logs_config(logs_config)

    def _make_new_stream_config(self):
        return configs_templates.stream_config(self.topic_path)

    def _make_new_log_config(self):
        return configs_templates.log_config(self.topic_path)

############################################################################

    def _run_config_tests(self):
        tests_result = arcadiasdk.do_build(
            consts.YMAKE_BUILD_SYSTEM,
            self.source_root_path,
            ["logfeller/configs/tests"],
            clear_build=False,
            test=True
        )
        if tests_result == arcadiasdk.INFRASTRUCTURE_ERROR_EXIT_CODE:
            return False
        return True

    def _commit(self):
        def parse_commit_output(output):
            committed_revision_re = re.compile("(.|\n)*Committed revision (?P<revision>[0-9]+)(.|\n)*")
            match = committed_revision_re.match(output)
            if not match:
                return None
            else:
                return match.group("revision")

        with sdk2.ssh.Key(self, "robot-deployer-logs", "RobotDepoyerLogs-RSA-Key"):
            commit_output = sdk2.svn.Arcadia.commit(self.configs_local_path, "auto commit - add new drug log {} SKIP_CHECK".format(self.topic_path), user="robot-deployer-logs")
            revision = parse_commit_output(commit_output)
            if revision:
                return revision
            else:
                raise Exception(commit_output)

    def commit_new_log(self):
        self._add_stream_config()
        self._add_log_config()

        if self._run_config_tests():
            self._commit()
        else:
            raise Exception("failed tests")
