def stream_config(topic_path):
    return {
        "topic_path": "{}".format(topic_path),
        "logbroker": "@stream_options:logbroker:common_arnold",
        "indexing_options": "@stream_options:indexing:schema_common",
        "parsing_options": {
            "chunk_splitter_name": "line-break",
            "parser_name": "cat-parser",
            "formatter_name": "native"
        },
        "lifetimes": "@stream_options:lifetimes:common"
    }


def log_config(topic_path):
    def make_log_name():
        return "{}-log".format(topic_path.replace("/", "-"))

    return {
        "name": make_log_name(),
        "cluster_name": "arnold",
        "streams": [
            "@streams:arnold:{}".format(topic_path)
        ],
        "periods": [
            "30min",
            "1d"
        ],
        "lifetimes": {
            "30min": "1d",
            "1d": "20d"
        },
        "build_options": "@log_options:build:common",
        "rebuild_options": "@log_options:rebuild:common",
        "archive_options": "@log_options:archive:common",
        "infer_yt_schema": True
    }
