from sandbox import sdk2


############################################################################


class ReleaseLogsToNirvactor(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group("Settings") as settings_block:
            yt_cluster = sdk2.parameters.String(
                "YT cluster",
                default="hume",
                required=True,
                choices=(("vanga", "vanga"), ("hahn", "hahn"), ("arnold", "arnold"), ("bohr", "bohr"), ("landau", "landau"), ("freud", "freud"), ("hume", "hume"))
            )

            revision = sdk2.parameters.Integer(
                "Revision number",
                required=False
            )

            # ---

            allow_downgrade = sdk2.parameters.Bool(
                "Allow downgrade",
                required=False,
                default=False
            )

        with sdk2.parameters.Group("Build settings") as build_settings_block:
            use_last_binary = sdk2.parameters.Bool(
                "Use last binary archive",
                default=True
            )

            custom_tasks_archive_resource = sdk2.parameters.Resource(
                "task archive resource",
                default=None,
            )

    ########################################################################################
    # utils

    @staticmethod
    def _get_yt_token():
        return sdk2.Vault.data("LOGFELLER_YT_TOKEN")

    @staticmethod
    def _get_nirvactor_token():
        return sdk2.Vault.data("LOGFELLER_STEP_TOKEN")

    ########################################################################################
    # callbacks

    def on_save(self):
        if self.Parameters.use_last_binary:
            self.Requirements.tasks_resource = sdk2.service_resources.SandboxTasksBinary.find(
                attrs={'target': 'logfeller/ReleaseLogsToNirvactor'}
            ).first().id
        else:
            self.Requirements.tasks_resource = self.Parameters.custom_tasks_archive_resource

    def on_execute(self):

        from logfeller.python.logfeller.infra.release.nirvactor.deploy_configs import deploy_configs, YT_TOKEN_SECRET_NAME_ROBOT_LOGFELLER

        ########################################################################################

        yt_cluster = str(self.Parameters.yt_cluster)
        revision = self.Parameters.revision

        path_to_logs = sdk2.svn.Arcadia.checkout(
            "arcadia:/arc/trunk/arcadia/logfeller/configs/logs",
            "./logs",
            revision=revision
        )

        ########################################################################################
        # temporary protection

        if yt_cluster not in ["vanga", "hahn", "arnold", "hume", "freud", "bohr", "landau"]:
            return

        ########################################################################################

        deploy_configs(
            yt_cluster,
            path_to_logs,
            revision,
            16,  # threads_num. After REACTOR-1176 it's possible to increase this
            YT_TOKEN_SECRET_NAME_ROBOT_LOGFELLER,
            self._get_yt_token(),
            self._get_nirvactor_token(),
            ignore_cache=False,
            is_dry_mode=False,
            is_sandbox=True,
            allow_downgrade=self.Parameters.allow_downgrade
        )

############################################################################
