from sandbox.projects.logfeller.common.deploy import DeployConfig, TestRunner, SvnFetcher

from sandbox import sandboxsdk
from sandbox import sdk2

import sys

############################################################################


class ReleaseMarketConfigsToYT(sdk2.Task):
    """Release files to YT cluster"""

    class Parameters(sdk2.Task.Parameters):
        yt_cluster = sdk2.parameters.String(
            "YT cluster",
            default="hume",
            required=True,
            choices=(("hume", "hume"), ("hahn", "hahn"), ("arnold", "arnold"))
        )

        yt_token_vault_name = sdk2.parameters.String(
            "YT tokent vault name",
            required=True,
        )

        revision = sdk2.parameters.Integer(
            "Revision number",
            required=True
        )
        message = sdk2.parameters.String(
            "Release message, say something to your colleagues",
        )

    class Requirements(sdk2.Requirements):
        environments = [sandboxsdk.environments.PipEnvironment('yandex-yt')]

    def get_yt_token(self):
        return sdk2.Vault.data(self.Parameters.yt_token_vault_name)

    def create_yt_client(self):
        import yt.wrapper as yt
        return yt.YtClient(
            proxy=self.Parameters.yt_cluster,
            token=self.get_yt_token()
        )

    def get_release_manager_class(self, yt_client, destination):
        sys.path.append(sandboxsdk.svn.Arcadia.get_arcadia_src_dir(
            "arcadia:/arc/trunk/arcadia/logfeller/python/logfeller/infra/release/yt"
        ))
        from manager import ReleaseManager
        return ReleaseManager(yt_client, destination)

    def on_execute(self):
        deploy_config = DeployConfig.read_from_arcadia("arcadia:/arc/trunk/arcadia/logfeller/deploy/yt/market_logs.json")

        TestRunner(self, deploy_config.tests, self.Parameters.revision).run_tests()

        svn_fetcher = SvnFetcher(
            deploy_config.source.path,
            deploy_config.source.files,
            self.Parameters.revision
        )
        local_dir, local_files = svn_fetcher.fetch_files()

        release_manager = self.get_release_manager_class(self.create_yt_client(), deploy_config.destination)
        release_manager.release(
            local_dir,
            local_files,
            self.Parameters.revision,
            self.author,
            self.Parameters.message,
            force=False,
            clean_up=False
        )

############################################################################
