# -*- coding: utf-8 -*-
from sandbox.sandboxsdk.environments import VirtualEnvironment
from sandbox.projects.common import utils
from sandbox.projects.common.arcadia import sdk
import sandbox.projects.common.constants as consts
from sandbox.common.errors import TaskFailure

from sandbox import sdk2
from sandbox.sdk2.vcs.svn import Arcadia
from sandbox.sdk2.helpers import ProcessLog, subprocess as sp

import os
import stat
from os.path import join as pj
from shutil import copyfile


TARGETS = ['quality/user_sessions/data_com/yt_tables',
           'quality/user_sessions/data_com/merge_details_to_dataset']


class DataComMakeDataset(sdk2.Task):
    class Parameters(sdk2.Parameters):
        kill_timeout = 4 * 3600
        arcadia_url = sdk2.parameters.ArcadiaUrl('Arcadia URL', default_value=Arcadia.ARCADIA_TRUNK_URL)
        token_owner = sdk2.parameters.String("Tokens owner for sb-vault-secrets. Default is task author")

    class Context(sdk2.Context):
        source_revision = None

    def on_execute(self):
        with sdk.mount_arc_path(self.Parameters.arcadia_url) as arcadia_dir:
            arcadia_info = utils.svn_revision(arcadia_dir) or utils.svn_revision(self.Parameters.arcadia_url)
            self.Context.source_revision = arcadia_info

            build_root = str(self.path('build'))
            sdk.do_build(build_system=consts.YMAKE_BUILD_SYSTEM,
                            build_type=consts.RELEASE_BUILD_TYPE,
                            source_root=arcadia_dir,
                            targets=TARGETS,
                            results_dir=build_root,
                            clear_build=False,
                            use_dev_version=False,
                            sanitize=False)

            for target in TARGETS:
                bin_name = os.path.basename(target)
                bin_src = pj(build_root, target, bin_name)
                bin_dst = pj(arcadia_dir, target, bin_name)

                copyfile(bin_src, bin_dst)
                os.chmod(bin_dst, os.stat(bin_dst).st_mode | stat.S_IEXEC)

            with VirtualEnvironment() as venv:
                venv.pip('pip==20.2.3')
                venv.pip('yandex-yt')

                clone_env = os.environ.copy()
                clone_env['PATH'] = arcadia_dir + ':' + clone_env.get('PATH', '')

                token_owner = self.Parameters.token_owner or self.author
                clone_env['YA_TOKEN'] = sdk2.Vault.data(token_owner, 'YA_TOKEN')
                clone_env['YT_TOKEN'] = sdk2.Vault.data(token_owner, 'YT_TOKEN')
                clone_env['YQL_TOKEN'] = sdk2.Vault.data(token_owner, 'YQL_TOKEN')

                script = 'update_dataset.sh'
                logger_name = 'update_dataset'
                log_name = 'update_dataset.out.log'

                with ProcessLog(self, logger=logger_name) as pl:
                    cmd = ['bash', '-e', '-x', pj(arcadia_dir, 'quality/user_sessions/data_com', script)]
                    proc = sp.Popen(cmd, stdout=pl.stdout, stderr=sp.STDOUT, env=clone_env)
                    proc.wait()
                    if proc.returncode != 0:
                        self.set_info('ERROR log is HERE >>>>: <a href="{}">{}</a>'.format(pj(self.log_resource.http_proxy, log_name), log_name), do_escape=False)
                        raise TaskFailure("{} exit code {} check {} for errors".format(script, proc.returncode, log_name))
