//

String.prototype.format = function () {
    var args = arguments;
    return this.replace(/{(\d+)}/g, function (match, number) {
        return typeof args[number] != 'undefined'
            ? args[number]
            : match;
    });
}

function CopyDict(d) {
    return $.extend(true, {}, d);
}

function Log(str) {
    console.log(str);
}

function CreateDiagKey(supportFields1, supportFields2, changedFields, // flags
                       diagnosis) {
    var res = {
        rec1Info: CopyDict(diagnosis.rec1Info),
        rec2Info: CopyDict(diagnosis.rec2Info),
        changeInfo: CopyDict(diagnosis.changeInfo)
    };

    // support fields 1
    for (fld in supportFields1) {
        if (!(fld in res.rec1Info) || supportFields1[fld])
            res.rec1Info[fld] = undefined;
    }

    // support fields 2
    for (fld in supportFields2) {
        if (!(fld in res.rec2Info) || supportFields2[fld])
            res.rec2Info[fld] = undefined;
    }

    // changed fields
    if (!('changeInfo' in res))
        res.changeInfo = {};
    for (fld in changedFields) {
        if (!(fld in res.changeInfo) || changedFields[fld])
            res.changeInfo[fld] = undefined;
    }

    return res;
}

// key2diag is a list of pairs
// Returns <diagnose> if found, undefined otherwise.
function FindDiagnoseByKey(key2diag, key) {
    for (var i = 0; i < key2diag.length; ++i) {
        if (key2diag[i][0] === key) {
            return key2diag[i][1];
        }
    }
    return undefined;
}

function AggregateDiagnoses(precompData) {
    var state = precompData.flags;
    var sf1 = state.support_fields1;
    var sf2 = state.support_fields2;
    var cf = state.changed_fields;
    var diagnoses = precompData.diagnoses;

    // key2diag is actually not a dict, but a list of pairs <key, diagnose>.
    // Why: it is used as ordered dict
    var key2diag = new Array();
    for (var i = 0; i < diagnoses.length; ++i) {
        var diag = diagnoses[i];
        var keyObj = CreateDiagKey(sf1, sf2, cf, diag);
        var keyStr = JSON.stringify(keyObj);
        var resDiag = FindDiagnoseByKey(key2diag, keyStr);
        if (resDiag === undefined) {
            resDiag = $.extend(true, {}, diag);
                resDiag.intervals = [];
                var pos = parseInt(resDiag.pos);
                var count = parseInt(resDiag.count);
                resDiag.intervals.push([pos, pos + count]);
            key2diag.push([keyStr, resDiag]);
        } else {
            resDiag.pos = undefined;
            resDiag.count += diag.count;

            var pos = parseInt(diag.pos);
            var count = parseInt(diag.count);
            resDiag.intervals.push([pos, pos + count]);
        }
    }

    var resDiagnoses = new Array();
    for (var i = 0; i < key2diag.length; ++i) {
        resDiagnoses.push(key2diag[i][1]);
    }

    var res = $.extend(true, {}, precompData);
    res.diagnoses = resDiagnoses;
    return res;
}

function Init(precompData) {
    staticPrecompData = CopyDict(precompData); //must be static
    Log('Initialization...');
    for (var data in precompData) {
        var table = new DiagnosisClassTable(precompData[data.toString()], data.toString());
        var rendered = table.Render();
        $("#tables-placement").append(rendered);
    }
    Log('Initialization completed.');
}

function _aggregateData(table, field) { //dummy mock
    var field_class = field.split(":")[0];
    var field_name = field.split(":")[1];
    Log(field_class);
    Log(field_name);
    staticPrecompData[table]['flags'][field_class][field_name] = !staticPrecompData[table]['flags'][field_class][field_name];
    var precompData = CopyDict(staticPrecompData[table]);
    return AggregateDiagnoses(precompData);
}

function fold(element) {
    var parentTable = $(element).parent().parent().parent()[0];
    var tableMarker = document.createElement("div");
    var markerId = parentTable.id + "marker";
    tableMarker.id = markerId;
    $(tableMarker).insertBefore("#" + parentTable.id);
    $("#" + parentTable.id).remove();
    var table = new DiagnosisClassTable(_aggregateData(parentTable.id, element.id), parentTable.id);
    console.log("test");
    var rendered = table.Render();
    $(rendered).insertAfter("#" + markerId);
    $("#" + markerId).remove();


}

var DiagnosisClassTable = function (classObject, objectName) {
    this.Flags = classObject.flags;
    this.Diagnoses = classObject.diagnoses;
    this.objectName = objectName;
    this.SourceSupportFields = this.Flags["support_fields1"] || {};
    this.DstSupportFields = this.Flags["support_fields2"] || {};
    this.ChangedFields = this.Flags["changed_fields"] || {};
};


function MakeCellFolded(cell) {
    cell.innerHTML = "<span class = \"glyphicon glyphicon-eye-close\" aria-hidden=\"true\">&nbsp; </span>";
}


DiagnosisClassTable.prototype.Render = function () {
    var table = document.createElement("table");
    table.className = "table table-hover table-bordered table-striped table-responsive";
    table.id = this.objectName;
    //Render table body
    this.Diagnoses.forEach(function (diagnosis) {
        var bodyRow = table.insertRow();
        var rec1Info = diagnosis["rec1Info"] || "";
        if (typeof rec1Info == "string") {
            var cell = bodyRow.insertCell();
            cell.textContent = rec1Info;
            cell.className = "success";
        } else {
            var cellInserted = false;
            for (var field in this.SourceSupportFields) {
                var cell = bodyRow.insertCell();
                cell.className = "success";
                if (field in rec1Info) {
                    cell.textContent = rec1Info[field];
                    if (this.SourceSupportFields[field] === true) {
                        MakeCellFolded(cell);
                    }
                }
                cellInserted = true;
            }
            if (cellInserted == false) {
                var cell = bodyRow.insertCell();
            }
        }

        var rec2Info = diagnosis["rec2Info"];
        if (typeof rec2Info == "string") {
            var cell = bodyRow.insertCell();
            cell.textContent = rec2Info;
            cell.className = "info";
        } else {
            var cellInserted = false;
            for (var field in this.DstSupportFields) {
                var cell = bodyRow.insertCell();
                if (field in rec2Info) {
                    cell.textContent = rec2Info[field];
                    if (this.DstSupportFields[field] === true) {
                        MakeCellFolded(cell);
                    }

                }
                cell.className = "info";
                cellInserted = true;
            }
            if (cellInserted == false) {
                var cell = bodyRow.insertCell();
                cell.className = "success";
            }
        }
        var changeInfo = diagnosis["changeInfo"] || {};
        for (var field in this.ChangedFields) {


            var cell = bodyRow.insertCell();
            cell.className = "danger";
            if (field in changeInfo) {
                cell.textContent = changeInfo[field];
                if (this.ChangedFields[field] === true) {
                    MakeCellFolded(cell);
                }
            }

        }


        var posCell = bodyRow.insertCell();
        if ("pos" in diagnosis && diagnosis["pos"] != undefined) {

            var href = document.createElement("a");
            var start_pos = parseInt(diagnosis["pos"]);
            var count = parseInt(diagnosis["count"]);
            href.href =  "https://yt.yandex-team.ru/hahn/navigation?path=//"
                                + DiagHashTable
                                + "&offsetValue={0}".format(start_pos)
                                + "&pageSize={0}".format(Math.max(count, 50))
                                + "&offsetMode=row";
            href.textContent = diagnosis["pos"];
            href.target = "_blank";
            posCell.appendChild(href);

        } else {
            posCell.textContent = "-";
        }
        bodyRow.insertCell().innerHTML = "<p class=\"bg-danger\"><strong>" + diagnosis.count.toString() + "</strong></p>";
        var intervals = JSON.stringify(diagnosis.intervals);
        intervals = intervals.replace(/\[/g, '(').replace(/\]/g, ')');
        intervals = '[' + intervals.substr(1, intervals.length-2) + ']';
        var button = document.createElement("button");
        button.className = "btn btn-default";
        var span = document.createElement("span");
        span.className = "glyphicon glyphicon-eye-open";
        span.setAttribute("aria-hidden", "true");
        button.appendChild(span);
        button.onclick = function() {
            alert(WorkDir + '/yt_massgrep.py --server hahn --fetch //' + FetchedDataPath +' --diagnosis_hash //' + DiagHashTable + ' --diapasons "' + intervals + '" --dest ' + DefaultDstTable)
        };
        bodyRow.insertCell().appendChild(button);


    }, this);

    //Render caption
    table.createCaption().innerHTML = "<b><mark>" + this.objectName.replace("2", " -> ") + "</mark></b>";

    //Render header
    var tableHeader = table.createTHead();
    tableHeader.style.borderBottom = "3px solid black";
    var infoRow = tableHeader.insertRow();

    var sup1InfoCell = infoRow.insertCell();
    sup1InfoCell.innerText = "Support fields - before";
    sup1InfoCell.className = "success";
    var sup2InfoCell = infoRow.insertCell();
    sup2InfoCell.innerText = "Support fields - tested";
    sup2InfoCell.className = "info";
    var changedInfoCell = infoRow.insertCell();
    changedInfoCell.innerText = "Changed fields";
    changedInfoCell.className = "danger";

    var suppFields1Count = 0;
    var suppFields2Count = 0;
    var changedFieldCount = 0;
    var row = tableHeader.insertRow();
    console.log("create table");
    for (var field in this.SourceSupportFields) {
        var collumn = row.insertCell();
        collumn.textContent = field.toString();
        collumn.className = "success aggregate";
        collumn.id = "support_fields1:" + collumn.textContent;
        if (this.SourceSupportFields[field]) {
            collumn.innerHTML += "<button class='btn btn-default'><span class=\"glyphicon glyphicon-fullscreen\" aria-hidden=\"true\"></span></button>";

        } else {
            collumn.innerHTML += "<button class='btn btn-default'><span class=\"glyphicon glyphicon-resize-small\" aria-hidden=\"true\"></span></button>";

        }
        suppFields1Count++;
    }

    for (var field in this.DstSupportFields) {
        var collumn = row.insertCell();
        collumn.textContent = field.toString();
        collumn.className = "info aggregate";
        collumn.id = "support_fields2:" + collumn.textContent;
        if (this.DstSupportFields[field]) {
            collumn.innerHTML += "<button class='btn btn-default'><span class=\"glyphicon glyphicon-fullscreen\" aria-hidden=\"true\"></span></button>";

        } else {
            collumn.innerHTML += "<button class='btn btn-default'><span class=\"glyphicon glyphicon-resize-small\" aria-hidden=\"true\"></span></button>";

        }
        suppFields2Count++;
    }

    for (var field in this.ChangedFields) {
        var collumn = row.insertCell();
        collumn.textContent = field.toString();
        collumn.className = "danger aggregate";
        collumn.id = "changed_fields:" + collumn.textContent;
        if (this.ChangedFields[field]) {
            collumn.innerHTML += "<button class='btn btn-default'><span class=\"glyphicon glyphicon-fullscreen\" aria-hidden=\"true\"></span></button>";

        } else {
            collumn.innerHTML += "<button class='btn btn-default'><span class=\"glyphicon glyphicon-resize-small\" aria-hidden=\"true\"></span></button>";

        }
        changedFieldCount++;
    }
    sup1InfoCell.colSpan = suppFields1Count;
    sup2InfoCell.colSpan = suppFields2Count;


    if (changedFieldCount > 0) {
        changedInfoCell.colSpan = changedFieldCount;
    } else {
        infoRow.deleteCell(-1);
    }

    row.insertCell().textContent = "position";
    row.insertCell().textContent = "count";
    row.insertCell().textContent = "Сформировать команду отбора";
    return table;
}
