# -*- coding: utf-8 -*-

import os
import json
import time
import logging
import posixpath

from sandbox.projects.ab_testing.resource_types import RUN_ABT_METRICS_REPORT
import sandbox.projects.common.binary_task as binary_task
from sandbox.projects.logs.KatiWrapper.lib import tokens
# from sandbox.projects.common import utils for debug
import sandbox.sdk2 as sdk2

# from sandbox.projects.logs.TestLogs.lib.tokens import get_secret
# from sandbox.projects.logs.TestLogs.lib.tokens import YT_ROBOT_MAKE_SESSIONS_SECRET_ID for debug


def get_task_yt_prefix(params):
    dst_path = params['dst_path']
    task_id = params['task_id']
    return '{}/{}/'.format(dst_path, task_id)


class KatiWrapper(sdk2.Task, binary_task.LastBinaryTaskRelease):
    class Requirements(sdk2.Requirements):
        pass

    class Parameters(sdk2.Task.Parameters):
        json_params = sdk2.parameters.String('json params')

        with sdk2.parameters.Output:
            metrics_id = sdk2.parameters.Integer("Resource with metrics.json file containing results of current run")

    # def start_local_yt(self, params=None):
    #     cypress_dir = os.path.abspath('./')
    #     server=yt_local.start(
    #         local_cypress_dir=cypress_dir,
    #     )
    #     yt_proxy = server.get_proxy_address()
    #     logging.debug('YT_PROXY:')
    #     logging.debug(yt_proxy)
    #     return server

    # def stop_local_yt(self, server, params=None):
    #     server.stop()
    #     logging.debug('LOCAL YT STOPPED')

    def run_kati(self, params, reqids=None):
        import quality.ab_testing.scripts.shellabt.shellabt as shellabt

        params['yt_token'] = tokens.get_secret(params['yt_token_secret_id'], params['yt_token_secret_name'])

        if 'output_prefix' not in params:
            params['output_prefix'] = params['dst_path']
        # if self.Context.is_debug:
        #     params = dict(
        #         task_id=str(self.id),
        #         yt_pool='bigdata_reserved',
        #         dst_path='//home/userdata-dev/zsafiullin/staticTables/research',
        #         output_prefix='//home/userdata-dev/zsafiullin/kati'
        #     )
        #     params['yt_token'] = get_secret(YT_ROBOT_MAKE_SESSIONS_SECRET_ID, 'secret')
        #     params['date'] = '2022-04-13'
        #     params['task_id'] = '1276922617'

        # TODO: Use config
        collector_config_path = 'sc_conf.txt'
        with open(collector_config_path, 'wt') as f:
            config = '[task]\nname=\n'
            reqids_filter = ''
            if reqids is not None:
                reqids_filter = 'filter=reqid_reg_filter:' + '|'.join(reqids) + '\n'
            config += reqids_filter
            config += 'experiment=0'
            f.write(config)
            logging.debug("WRITTEN CONFIG FOR KATI")

        sample_path = get_task_yt_prefix(params)
        if self.Context.is_debug:
            sample_path = '//home/userdata-dev/zsafiullin/staticTables/research/1276922617/'

        logging.debug("SAMPLE_PATH")
        logging.debug(sample_path)

        package_id = 2943612528  # tmp resource that was build locally
        # package_id = utils.get_or_default(self.ctx, self.Package)
        # package_id = 'stable'
        # if package_id == "stable":
        #     logging.info('Stable released package_id was requested')

        #     package_id = self._get_latest_stable_abt_package_id()
        #     logging.info('Found stable package_id %s', package_id)

        #     if package_id is None:
        #         raise ValueError("Failed to retrieve stable package_id")

        logging.info('Syncing resource: %d', package_id)
        package_resource = sdk2.Resource.find(id=package_id).first()
        package_path = str(sdk2.ResourceData(package_resource).path)

        logging.debug("PACKAGE_PATH")
        logging.debug(package_path)

        conf = shellabt.FreeConfig()
        conf['server'] = 'hahn'
        conf['date'] = params['date']
        conf['date'] = ''.join(conf['date'].split('-'))
        conf['yt_prefix'] = sample_path

        extract_to = './'
        logging.info('Extracting: %s to %s', package_path, extract_to)
        paths = shellabt.DebianYaPackagePaths(package_path, '/Berkanavt/ab_testing/bin', extract_to)
        conf.merge(paths)

        conf['yt_token'] = params['yt_token']
        conf['yt_pool'] = params['yt_pool']

        conf['output_prefix'] = '{}/{}/'.format(params['output_prefix'], params['task_id'])
        conf['yt_tmp'] = posixpath.join(conf['output_prefix'], 'tmp')
        conf['collector_out_table'] = '%srun_abt_metrics_%s_%s_%d' % (conf['output_prefix'], conf['date'], package_id, int(time.time()))

        stat = shellabt.StatRunner(conf)

        features_id = ""
        metrics_id = ""
        try:
            features_id = stat.get_features_stat_collector(config_path=collector_config_path).get('changes_info', {}).get('id_resource_sandbox', "")
        except Exception as e:
            logging.info('Exception in get_features_stat_collector: {}'.format(e))

        try:
            metrics_id = stat.get_metrics_stat_fetcher().get('changes_info', {}).get('id_resource_sandbox', "")
        except Exception as e:
            logging.info('Exception in get_metrics_stat_fetcher {}'.format(e))

        logging.info('Obtained id of resource of metrics({}) and features_custom({})'.format(metrics_id, features_id))

        stat.run_stat_collector(
            config_path=collector_config_path,
            target_date=conf['date'],
            result_table=conf['collector_out_table']
        )

        logging.info('Set expiration for %s', conf['collector_out_table'])
        from yt.wrapper import YtClient
        client = YtClient(proxy=conf['server'], token=conf['yt_token'])
        client.set_attribute(conf['collector_out_table'], 'expiration_time', int(time.time() + 36 * 60 * 60) * 1000)

        conf['fetcher_out_path'] = 'result.txt'

        stat.run_stat_fetcher(
            config_path=collector_config_path,
            target_date=conf['date'],
            collector_table=conf['collector_out_table'],
            result_path=conf['fetcher_out_path']
        )

        metrics_info = shellabt.load_only_metrics(conf['stat_fetcher'])
        result = shellabt.StatResult.from_file(conf['fetcher_out_path'], metrics_info)

        suite = shellabt.SuiteResult.from_sample_path(sample_path)
        suite.add(result)

        filename_fetcher = 'metrics.json'
        fetcher_file = os.path.abspath(filename_fetcher)
        suite.to_file(fetcher_file)

        description = 'metrics.json for test_logs'
        resource = RUN_ABT_METRICS_REPORT(self, description, fetcher_file)

        return resource.id

    def on_execute(self):
        # self.Context.is_debug = True

        params = json.loads(self.Parameters.json_params)
        reqids = params.get('reqids')

        metrics_id = self.run_kati(params, reqids)
        self.Parameters.metrics_id = metrics_id
