# -*- coding: utf-8 -*-

import os
import logging
import subprocess

from sandbox import common
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.projects.logs import resources
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.parameters import ResourceSelector, SandboxStringParameter
from sandbox.projects.common import apihelpers
import sandbox.projects.sandbox


class LogName(SandboxStringParameter):
    name = 'log_name'
    description = 'Log name'
    multiline = False
    required = True
    choices = (
        ('access', 'access'),
        ('antirobot_daemon', 'antirobot_daemon'),
        ('blockstat', 'blockstat'),
        ('direct', 'direct'),
        ('direct_urls', 'direct_urls'),
        ('img_reqans', 'img_reqans'),
        ('maps_reqans', 'maps_reqans'),
        ('maps_reqans_new', 'maps_reqans_new'),
        ('market_access', 'market_access'),
        ('market_clicks', 'market_clicks'),
        ('market_report', 'market_report'),
        ('market_shows', 'market_shows'),
        ('mobreport_access', 'mobreport_access'),
        ('mobreport_blockstat', 'mobreport_blockstat'),
        ('portal_access', 'portal_access'),
        ('portal_blockstat', 'portal_blockstat'),
        ('profile_log', 'profile_log'),
        ('provider_masterbit', 'provider_masterbit'),
        ('provider_wnet', 'provider_wnet'),
        ('redir', 'redir'),
        ('reqans', 'reqans'),
        ('saas_access', 'saas_access'),
        ('saas_reqans', 'saas_reqans'),
        ('share_access', 'share_access'),
        ('similargroup', 'similargroup'),
        ('similargroup_mobile', 'similargroup_mobile'),
        ('spy_log', 'spy_log'),
        ('spy_log_tskv', 'spy_log_tskv'),
        ('video_reqans', 'video_reqans'),
        ('watch_log', 'watch_log'),
        ('watch_log_tskv', 'watch_log_tskv'),
        ('xml_reqans', 'xml_reqans'),
        ('ymusic_reqans', 'ymusic_reqans')
    )


class InputData(SandboxStringParameter):
    name = 'input_data'
    description = 'Входные данные'
    multiline = True


class CreateSessionsTestsBinary(ResourceSelector):
    name = 'create_sessions_tests_resource_id'
    description = 'Бинарник, которым будем проверять'
    required = True
    resource_type = resources.CREATE_SESSIONS_TESTS_EXECUTABLE

    @common.utils.classproperty
    def default_value(cls):
        resource = apihelpers.get_last_released_resource(cls.resource_type)
        return resource.id if resource else None


class ParsibilityTester(SandboxTask):
    type = "PARSIBILITY_TESTER_FOR_SESSIONS_CREATE"

    input_parameters = [LogName, InputData, CreateSessionsTestsBinary]

    def __init__(self, *args, **kwargs):
        SandboxTask.__init__(self, *args, **kwargs)
        self.env = dict(os.environ)

    def RunProcess(self, cmd, input=None):
        process = run_process(
            cmd,
            wait=True,
            outs_to_pipe=True,
            check=False,
            stdin=subprocess.PIPE if input else None,
            stdout=subprocess.PIPE,
            shell=True,
            environment=self.env
        )
        result, error = process.communicate(input)
        if process.returncode != 0:
            raise Exception(error)

        return result

    def on_execute(self):
        logging.info('file input_data: ' + self.ctx['input_data'])
        geohelper_path = self.sync_resource(apihelpers.get_last_released_resource(resources.SESSIONS_GEOHELPER))
        user_type_resolver_path = self.sync_resource(apihelpers.get_last_released_resource(resources.SESSIONS_USER_TYPE_RESOLVER))
        beta_list_path = self.sync_resource(apihelpers.get_last_released_resource(resources.SESSIONS_BETA_LIST))
        blockstat_path = self.sync_resource(apihelpers.get_last_released_resource(resources.SESSIONS_BLOCKSTAT))

        create_sessions_tests_path = self.sync_resource(self.ctx['create_sessions_tests_resource_id'])

        # ###################################################################################
        with open('input.txt', 'w+') as input_file:
            input_file.write(self.ctx['input_data'].encode('utf-8'))

        file_params = ' -geohelper ' + geohelper_path + ' -user_type_resolver ' + user_type_resolver_path + ' -bsdict ' + blockstat_path + ' -beta_list ' + beta_list_path
        create_sessions_cmd = create_sessions_tests_path + ' -' + self.ctx['log_name'] + ' input.txt -with_uid -with_ts -with_table_type ' + file_params
        logging.info('create_sessions_cmd: ' + create_sessions_cmd)
        result = self.RunProcess(create_sessions_cmd)

        logging.info('res:\n' + result)

        # ###################################################################################
        with open('results.txt', 'w+') as f:
            f.write(result)
            self.create_resource('Результат построения сессий', 'results.txt', sandbox.projects.sandbox.TestTaskResource)


__Task__ = ParsibilityTester
