# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.parameters import (
    SandboxStringParameter,
    SandboxArcadiaUrlParameter,
    SandboxSelectParameter,
    ResourceSelector,
)

from sandbox.projects import resource_types
from sandbox.projects.logs import resources


def group_params(params, group_name):
    for p in params:
        p.group = group_name

    return params


class MapreduceCluster(SandboxStringParameter):
    """
        Кластер, на котором работаем
    """
    name = 'mr_cluster'
    description = 'MR cluster where all jobs will work'
    default_value = 'sakura00:8013'


class DataFolder(SandboxStringParameter):
    name = 'data_folder'
    description = 'Папка, в которой лежат выжимки. Если в папке есть таблица meatpath, то путь будет взят из нее, если нет, то будет использован текущий.'
    default_value = 'autotest_create_sessions'


class ReleaseParam(SandboxStringParameter):
    name = 'release_param'
    description = 'RELEASE_PARAM: Параметр релиза (обычно дата), который будет использоваться в директориях для результатов тестирования'
    default_value = 'YYYY_MM_DD'


class LogsListManual(SandboxStringParameter):
    """
        Имена логов, разделенные запятыми, для которых нужно запускать тестирование
    """
    name = 'logs_list_manual'
    description = 'Имена логов, разделенные запятыми, для которых нужно запускать тестирование'


class SvnBranch1(SandboxArcadiaUrlParameter):
    name = 'svn_path1'
    description = 'Svn url for branch'
    default_value = SandboxArcadiaUrlParameter.default_value + '@HEAD'


class Branch1MrCatRes(ResourceSelector):
    name = 'branch1_mr_cat_binary'
    description = 'Бинарник mr_cat'
    resource_type = resource_types.MR_CAT


class Branch1MrLsRes(ResourceSelector):
    name = 'branch1_mr_ls_binary'
    description = 'Бинарник mr_ls'
    resource_type = resource_types.MR_LS


class Branch1MapreduceYtRes(ResourceSelector):
    name = 'branch1_mapreduce_yt_binary'
    description = 'Бинарник mapreduce_yt'
    resource_type = resource_types.MAPREDUCE_YT_EXECUTABLE


class Branch1CreateSessionsRes(ResourceSelector):
    name = 'branch1_create_sessions_binary'
    description = 'Бинарник create_sessions'
    resource_type = resources.CREATE_SESSIONS_EXECUTABLE


class Branch1UserSessionsErrorsRes(ResourceSelector):
    name = 'branch1_user_sessions_errors_binary'
    description = 'Бинарник user_sessions_errors'
    resource_type = resources.USER_SESSIONS_ERRORS_EXECUTABLE


class BranchBuildSelectorBase(SandboxSelectParameter):
    choices = [
        ('from svn', 'from_svn'),
        ('auto pick packages', 'from_auto_packages'),
        ('pick packages', 'from_package')
    ]

    default_value = choices[0][1]
    description = "Откуда брать бинарники"


class BranchBuild1Selector(BranchBuildSelectorBase):
    name = 'revision1_build_type'
    sub_fields = {
        'from_package': [
            Branch1MrCatRes.name,
            Branch1MrLsRes.name,
            Branch1MapreduceYtRes.name,
            Branch1CreateSessionsRes.name,
            Branch1UserSessionsErrorsRes.name,
        ],
        'from_svn': [SvnBranch1.name],
        'from_auto_packages': [SvnBranch1.name]
    }


class SessionsSuffix1(SandboxStringParameter):
    name = 'sess_suffix1'
    description = 'Суффикс папки. в которую будут сохранены сессии, собранные первой ревизией'
    default_value = 'sessions1'


class SessionsSuffix1Selector(SandboxSelectParameter):
    name = 'sess_suffix1_folder_selector'
    choices = [('auto', 'auto'), ('manually', 'manually')]
    sub_fields = {'auto': [], 'manually': [SessionsSuffix1.name]}
    default_value = choices[0][1]
    description = """Задать вручную суффикс папки, в которую будут сохранены сессии, собранные первой ревизией.
Автоматический путь : us_release/[RELEASE_PARAM]/first"""


class SvnBranch2(SandboxArcadiaUrlParameter):
    name = 'svn_path2'
    description = 'Svn url for branch'
    default_value = SandboxArcadiaUrlParameter.default_value + '@HEAD'


class Branch2MrCatRes(ResourceSelector):
    name = 'branch2_mr_cat_binary'
    description = 'Бинарник mr_cat'
    resource_type = resource_types.MR_CAT


class Branch2MrLsRes(ResourceSelector):
    name = 'branch2_mr_ls_binary'
    description = 'Бинарник mr_ls'
    resource_type = resource_types.MR_LS


class Branch2MapreduceYtRes(ResourceSelector):
    name = 'branch1_mapreduce_yt_binary'
    description = 'Бинарник mapreduce_yt'
    resource_type = resource_types.MAPREDUCE_YT_EXECUTABLE


class Branch2CreateSessionsRes(ResourceSelector):
    name = 'branch2_create_sessions_binary'
    description = 'Бинарник create_sessions'
    resource_type = resources.CREATE_SESSIONS_EXECUTABLE


class Branch2UserSessionsErrorsRes(ResourceSelector):
    name = 'branch2_user_sessions_errors_binary'
    description = 'Бинарник user_sessions_errors'
    resource_type = resources.USER_SESSIONS_ERRORS_EXECUTABLE


class Branch2SessionsDiffRes(ResourceSelector):
    name = 'branch2_sessions_diff_binary'
    description = 'Бинарник sessions_diff'
    resource_type = resources.HASHED_SESSIONS_DIFF_EXECUTABLE


class BranchBuild2Selector(BranchBuildSelectorBase):
    name = 'revision2_build_type'
    sub_fields = {
        'from_package': [
            Branch2MrCatRes.name,
            Branch2MrLsRes.name,
            Branch2MapreduceYtRes.name,
            Branch2CreateSessionsRes.name,
            Branch2UserSessionsErrorsRes.name,
            Branch2SessionsDiffRes.name
        ],
        'from_svn': [SvnBranch2.name],
        'from_auto_packages': [SvnBranch2.name]
    }


class SessionsSuffix2(SandboxStringParameter):
    name = 'sess_suffix2'
    description = 'Суффикс папки. в которую будут сохранены сессии, собранные второй ревизией'
    default_value = 'sessions2'


class SessionsSuffix2Selector(SandboxSelectParameter):
    name = 'sess_suffix2_folder_selector'
    choices = [('auto', 'auto'), ('manually', 'manually')]
    sub_fields = {'auto': [], 'manually': [SessionsSuffix2.name]}
    default_value = choices[0][1]
    description = """Задать вручную суффикс папки, в которую будут сохранены сессии, собранные второй ревизией.
Автоматический путь : us_release/[RELEASE_PARAM]/second"""


class DestinationFolder(SandboxStringParameter):
    name = 'destination_folder'
    description = 'Папка, в которую будут сохранены диффы. Если не задан, то диффы сохраняем в <meatpath>/diff/<uuid>'
    default_value = ''


class DestinationFolderSelector(SandboxSelectParameter):
    name = 'destination_folder_selector'
    choices = [('auto', 'auto'), ('manually', 'manually')]
    sub_fields = {'auto': [], 'manually': [DestinationFolder.name]}
    default_value = choices[0][1]
    description = """Задать вручную директорию, в которую будут сохранены диффы.
Автоматический путь : us_release/[RELEASE_PARAM]"""


class YTToken(SandboxStringParameter):
    name = 'yt_token'
    description = 'Name of secret with YT token (from sb-vault)'


class YTTokenOwner(SandboxStringParameter):
    name = 'yt_token_owner'
    description = 'Owner of secret with YT token (default: owner of task)'


LeftRevisionParams = group_params(
    [
        BranchBuild1Selector,
        SvnBranch1,
        Branch1MrCatRes,
        Branch1MrLsRes,
        Branch1CreateSessionsRes,
        Branch1UserSessionsErrorsRes,
        SessionsSuffix1Selector,
        SessionsSuffix1
    ],
    'Left revision'
)

RightRevisionParams = group_params(
    [
        BranchBuild2Selector,
        SvnBranch2,
        Branch2MrCatRes,
        Branch2MrLsRes,
        Branch2CreateSessionsRes,
        Branch2UserSessionsErrorsRes,
        Branch2SessionsDiffRes,
        SessionsSuffix2Selector,
        SessionsSuffix2
    ],
    'Right revision'
)

CommonParams = group_params(
    [
        ReleaseParam,
        LogsListManual,
        MapreduceCluster,
        DestinationFolderSelector,
        DestinationFolder,
        DataFolder,
        YTToken,
        YTTokenOwner,
    ],
    'Common'
)
