# -*- coding: utf-8 -*-

import os
import shutil

from sandbox import sdk2
from sandbox.projects.common import error_handlers as eh
from sandbox.projects.common import link_builder as lb

import logging


class Sandbox2Arcadia(sdk2.Task):
    """
        Скачивает последний релизнутый ресурс из sandbox таски и коммитит его в аркадию.
    """

    name = 'SANDBOX_TO_ARCADIA'

    class Parameters(sdk2.Task.Parameters):
        resource_name = sdk2.parameters.String('Name of sandbox resource', required=True)
        resource_path = sdk2.parameters.String('Source path in sandbox resource', required=True)
        target_path = sdk2.parameters.String('Target path for commit', required=True)
        author = sdk2.parameters.String('Author of commit', default='zomb-sandbox-rw', required=True)

    def on_execute(self):
        dst_name = os.path.basename(self.Parameters.target_path)
        fresh_resource = sdk2.Resource[self.Parameters.resource_name].find(attrs={"released": "stable"}).first()
        svn_url = sdk2.svn.Arcadia.trunk_url(self.Parameters.target_path)
        svn_dir = sdk2.svn.Arcadia.get_arcadia_src_dir(os.path.dirname(svn_url))
        eh.verify(svn_dir, "Commit directory set by target_path parameter should not be None. Maybe path {} does not exist".format(self.Parameters.target_path))
        svn_dir = str(svn_dir)

        sync_path = str(sdk2.ResourceData(fresh_resource).path)
        logging.info("Resource %s, res_id %s; url %s; dir %s; sync_path %s", fresh_resource, fresh_resource.id, svn_url, svn_dir, sync_path)

        shutil.copy(os.path.join(sync_path, self.Parameters.resource_path), os.path.join(svn_dir, os.path.basename(dst_name)))
        svn_list = sdk2.svn.Arcadia.list(svn_dir).split()
        if dst_name not in svn_list:
            sdk2.svn.Arcadia.add(os.path.join(svn_dir, dst_name))
        logging.info('ARCADIA STATUS...\n%s', sdk2.svn.Arcadia.status(svn_dir))
        logging.info("ARCADIA DIFF...\n%s", sdk2.svn.Arcadia.diff(svn_dir))

        comment = "Update resource file: {}\n{} by {}\n{}".format(dst_name, self.type, self.owner, lb.task_link(self.id, plain=True))
        sdk2.svn.Arcadia.commit(svn_dir, comment, self.Parameters.author)
