# -*- coding: utf-8 -*-
import time
import logging
from sandbox import sdk2
import datetime
import json
import re
from sandbox.common.types import task as ctt
import sandbox.common.types.misc as ctm
import sandbox.common.types.notification as ctn
import sandbox.sandboxsdk.environments as environments
import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.input_params2 as rm_params
from sandbox.projects.logs.SurplusDiffTest.RunSurplusMetrics import RunSurplusMetrics
from sandbox.projects.logs.SurplusDiffTest.RunSurplusMetrics import SurplusMetricsResult
from sandbox.projects.logs.SurplusDiffTest.SurplusMetricsTaskReleaser import SurplusMetricsTaskReleaser
from sandbox.projects.release_machine_tasks.ReleaseSearchComponentZ2 import ReleaseSearchComponentZ2
from sandbox.projects.release_machine.components.configs.user_sessions import UserSessionsCfg
from sandbox.projects.common.build.YaPackage import YaPackage
from sandbox.projects.logs.UserSessionsProcessesTest import UserSessionsProcessesTest
from sandbox.projects.logs.release_helpers.UserSessionsHelper import UserSessionsHelper
import sandbox.projects.release_machine.rm_notify as rm_notify
from sandbox.projects.release_machine.rm_notify import const
from sandbox.projects.logs.release_binaries import ReleaseUserSessionsBinaries

MIN_DIFF_THRESHOLD = 0.01

# Warning! Its a copy-paste of DiffRuleMonitoring, will be refactored in the scope of LOGS-2126
class SurplusMetricsDiffHelper:
    HEAD_TEMPLATE = '''<!DOCTYPE html><html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Surplus metrics diff</title>
    </head>
    <body>
    {}
    </body>
    </html>'''
    TABLE_3_TEMPLATE = '''<table border="1" cellpadding="5" align="center" style="border-collapse: collapse; border: 1px solid black;"><thead>
    <tr><td></td><td>Commit in production</td><td colspan="3">Previous commit</td><td colspan="3">Your commit</td></tr>
    <tr><td>Metrica Name</td><td>Base Value</td><td>status</td><td>new value</td><td>diff</td><td>status</td><td>new value</td><td>diff</td></tr>
    </thead><tbody>'''
    TABLE_4_TEMPLATE = '<table border="1" cellpadding="5" align="center" style="border-collapse: collapse; border: 1px solid black;"><tr><td></td><td></td><td colspan="3">Old CS NEW RuleMonitoring</td><td colspan="3">New CS Old RuleMonitoring</td><td colspan="3">NEW CS NEW RuleMonitoring</td></tr><tr><td>Metrica Name</td><td>Base Value</td><td>status</td><td>new value</td><td>diff</td><td>status</td><td>new value</td><td>diff</td><td>status</td><td>new value</td><td>diff</td></tr>'
    TR_3_TEMPLATE = "<tr><td>{}</td><td>{}</td>{}{}</tr>"
    TR_4_TEMPLATE = "<tr><td>{}</td><td>{}</td>{}{}{}</tr>"
    TD_TEMPLATE = "<td>{}</td><td>{}</td><td>{}</td>"

    HAS_DIFF_TEMPLATE = '<font id="HAS_DIFF" style="color: #000000; background-color: #FFFF00">HAS_DIFF</font>'
    MINOR_DIFF_TEMPLATE = '<font id="MINOR_DIFF" style="color: #888888; background-color: #FFFFFF">MINOR_DIFF</font>'
    ADD_VALUE_TEMPLATE = '<font id="ADD" style="color: #ffffff; background-color: #66CC66">ADDED</font>'
    REMOVE_VALUE_TEMPLATE = '<font id="REMOVE" style="color: #ffffff; background-color: #FF3333">REMOVED</font>'

    OODICT = dict()
    ONDICT = dict()
    NODICT = dict()
    NNDICT = dict()

    is_two_rm = True
    has_diff = False

    def __init__(self, base_res, on_res, no_res, nn_res=None):
        pred = lambda x: re.match('(ru\|)?src-block_(main|parallel)_[0-9]+', x) is not None
        self.prepare_dict(self.OODICT, base_res, pred)
        self.prepare_dict(self.ONDICT, on_res, pred)
        self.prepare_dict(self.NODICT, no_res, pred)
        if no_res and nn_res:
            self.is_two_rm = False
            self.prepare_dict(self.NNDICT, nn_res, pred)

    def get_html(self, result_dir, keep_OK_metrics = False):
        result_html = open(result_dir, "w")
        if not self.is_two_rm:
            result_html.write(self.prepare_4_res_html(self.OODICT, self.ONDICT, self.NODICT, self.NNDICT, keep_OK_metrics))
        else:
            result_html.write(self.prepare_3_res_html(self.OODICT, self.ONDICT, self.NODICT, keep_OK_metrics))
        result_html.close()


    def prepare_3_res_html(self, OODICT, previousCommit, ONDICT, keep_OK_metrics=False):
        tr_add = []
        tr_remove = []
        tr_has_diff = []
        tr_no_diff = []
        table = self.TABLE_3_TEMPLATE
        all_keys = set(OODICT.keys())
        all_keys.update(set(ONDICT.keys()))
        all_keys.update(set(previousCommit.keys()))
        for key in sorted(all_keys):
            base_value = OODICT[key] if key in OODICT else "-"
            previous_commit_td = self.prepare_td(key, base_value, previousCommit[key] if key in previousCommit else "-")
            on_td = self.prepare_td(key, base_value, ONDICT[key] if key in ONDICT else "-")
            tr = self.TR_3_TEMPLATE.format(key, base_value, previous_commit_td, on_td)
            if 'id="HAS_DIFF"' in tr:
                tr_has_diff.append(tr)
            elif 'id="ADD"' in tr:
                tr_add.append(tr)
            elif 'id="REMOVE"' in tr:
                tr_remove.append(tr)
            elif keep_OK_metrics:
                tr_no_diff.append(tr)
        if len(tr_has_diff) + len(tr_remove) + len(tr_add) > 0:
            self.has_diff = True
        table = table + ''.join(tr_add) + ''.join(tr_remove) + ''.join(tr_has_diff) + ''.join(tr_no_diff) + '</table>'
        return self.HEAD_TEMPLATE.format(table)

    def prepare_4_res_html(self, OODICT, ONDICT, NODICT, NNDICT, keep_OK_metrics = False):
        tr_add = []
        tr_remove = []
        tr_has_diff = []
        tr_no_diff = []
        table = self.TABLE_4_TEMPLATE
        all_keys = set(OODICT.keys())
        all_keys.update(set(ONDICT.keys()))
        all_keys.update(set(NODICT.keys()))
        all_keys.update(set(NNDICT.keys()))
        for key in sorted(all_keys):
            base_value = OODICT[key] if key in OODICT else "-"
            on_td = self.prepare_td(key, base_value, ONDICT[key] if key in ONDICT else "-")
            no_td = self.prepare_td(key, base_value, NODICT[key] if key in NODICT else "-")
            nn_td = self.prepare_td(key, base_value, NNDICT[key] if key in NNDICT else "-")
            tr = self.TR_4_TEMPLATE.format(key, base_value, on_td, no_td, nn_td)
            if 'id="HAS_DIFF"' in tr:
                tr_has_diff.append(tr)
            elif 'id="ADD"' in tr:
                tr_add.append(tr)
            elif 'id="REMOVE"' in tr:
                tr_remove.append(tr)
            else:
                tr_no_diff.append(tr)
        if len(tr_has_diff) + len(tr_remove) + len(tr_add) > 0:
            self.has_diff = True
        if keep_OK_metrics:
            table = table + ''.join(tr_add) + ''.join(tr_remove) + ''.join(tr_has_diff) + ''.join(tr_no_diff) + '</table>'
        else:
            table = table + ''.join(tr_add) + ''.join(tr_remove) + ''.join(tr_has_diff) + '</table>'
        return self.HEAD_TEMPLATE.format(table)

    def prepare_td(self, key, base_value, new_value):
        status = None
        diff = None
        if base_value == new_value:
            status = 'OK'
            diff = '&nbsp;'
        else:
            if base_value == '-':
                status = self.ADD_VALUE_TEMPLATE
                diff = '{}'.format(new_value)
            else:
                if new_value == '-':
                    status = self.REMOVE_VALUE_TEMPLATE
                    diff = 'NO_VALUE'
                else:
                    status = self.HAS_DIFF_TEMPLATE
                    diff_value = new_value-base_value
                    if base_value == 0:
                        base_value = 1
                    diff_percente = diff_value/base_value*100
                    diff = '{} ({} %)'.format(diff_value, round(diff_percente, 2))
                    if abs(diff_percente) > MIN_DIFF_THRESHOLD:
                        status = self.HAS_DIFF_TEMPLATE
                    else:
                        status = self.MINOR_DIFF_TEMPLATE
        return self.TD_TEMPLATE.format(status, new_value, diff)

    def prepare_dict(self, dict, file, pred):
        with open(file, 'r') as result_file:
            for line in result_file:
                if len(line) == 0:
                    continue
                json_value = json.loads(line)
                name = ''
                if 'reqid' in json_value:
                    name += 'reqid={reqid}.'.format(reqid=json_value['reqid'])
                if 'uid' in json_value:
                    name += 'uid={uid}.'.format(uid=json_value['uid'])

                name += 'metric_name='+json_value['metric_name']

                if not pred(json_value['metric_name']):
                    continue

                key_columns = ['metric_name', 'reqid', 'uid']
                for key,value in json_value.iteritems():
                    if not key in key_columns:
                        dict[name + '.' + key] = float(value)

class UserSessionsSurplusMetricsInfo(sdk2.Resource):
    """
      Surplus metrics info for trunk run
    """
    releasers = ["ARC_AUTOCOMMIT_USERS", "USERSESSIONSTOOLS"]
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    branch = sdk2.parameters.String()
    table = sdk2.parameters.String()

class UserSessionsSurplusMetricsInfoForRelease(sdk2.Resource):
    """
       Surplus metrics run for release machine
    """
    releasers = ["ARC_AUTOCOMMIT_USERS", "USERSESSIONSTOOLS"]
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    branch = sdk2.parameters.String()


DEFAULT_ARCADIA_URL = 'arcadia:/arc/trunk/arcadia@4228478'
YQL_TOKEN_OWNER = 'USERSESSIONSTOOLS'
YQL_TOKEN_NAME = 'userdata-sessions-build-ci-token'

@rm_notify.notify2()
class DeploySurplusMetricsResult(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        cores = 1
        ram = 8192
        disk_space = 50 * 1024
        environments = [
            environments.PipEnvironment('yandex-yt', version='0.10.8'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet')
        ]

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(rm_params.ComponentName2):
        is_get_old_branch_auto = sdk2.parameters.Bool(
            "Get previous Surplus Metrics path automatically",
            default=True,
        )
        is_release_machine_mode = sdk2.parameters.Bool(
            "Collect user sessions logs from raw, and check 4 situations",
            default=False,
        )
        commit_author = sdk2.parameters.String("Author of new commit", default=None)
        is_set_custom_table = sdk2.parameters.Bool(
            "Set table path manually",
            default=False,
        )

        with is_set_custom_table.value[True]:
            custom_table = sdk2.parameters.String("custom table path", default=None)
            custom_table_for_new_commit = sdk2.parameters.String("custom table path for new_commits", default=None)
        with is_get_old_branch_auto.value[False]:
            old_revision = sdk2.parameters.ArcadiaUrl('path for old release branch', required=False)
        new_revision = sdk2.parameters.ArcadiaUrl('path for new release branch', required=False)
        release_number = sdk2.parameters.String('SM release number', required=False)
        arcadia_patch = sdk2.parameters.String('patch', required=False)
        just_testing_no_release = sdk2.parameters.Bool(
            "just testing no release",
            default=False,
        )

        show_OK_metrics = sdk2.parameters.Bool(
            "shown OK metrics in rule monitoring diff",
            default=False,
        )

        is_set_custom_surplus_metrics_tasks_ids = sdk2.parameters.Bool(
            "Set surplus_metrics child tasks ids manually",
            default=False,
        )

        with sdk2.parameters.RadioGroup("metrics mode") as metrics_mode:
            metrics_mode.values.summary = metrics_mode.Value("summary", default=True)
            metrics_mode.values.full = metrics_mode.Value("full")

        with is_set_custom_surplus_metrics_tasks_ids.value[True]:
            custom_old_CS_old_SM_id = sdk2.parameters.String("Custom old_CS_old_SM_id", default=None)
            custom_old_CS_new_SM_id = sdk2.parameters.String("Custom old_CS_new_SM_id", default=None)
            custom_new_CS_old_SM_id = sdk2.parameters.String("Custom new_CS_old_SM_id", default=None)
            custom_new_CS_new_SM_id = sdk2.parameters.String("Custom new_CS_new_SM_id", default=None)

    def get_prepared_logs_table(self):
        import yt.wrapper
        yt.wrapper.config.set_proxy("hahn")
        yt.wrapper.config["token"] = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
        table = "//home/userdata-sessions-build-ci/rule_monitoring/fresh_table"
        cl = yt.wrapper.read_table(table, format='json', raw=False)
        for item in cl:
            return item["value"]

    def get_sesions_path(self):
        if not self.Parameters.is_release_machine_mode:
            return self.get_prepared_logs_table()
        import yt.wrapper as yt

        yt.config.set_proxy("hahn")
        yt.config["token"] = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
        da = datetime.datetime.now()
        da = da.replace(hour=3, minute=0, second=0)
        ts = int(time.mktime(da.timetuple()))
        table_str = "//user_sessions/pub/search/fast/{}/clean"
        table = table_str.format(ts)
        if not yt.exists(table):
            da = da - datetime.timedelta(days=1)
            while not yt.exists(table):
                da = da + datetime.timedelta(minutes=30)
                table = table_str.format(int(time.mktime(da.timetuple())))
        self.Context.date_time = da.strftime("%Y-%m-%d:%H:%M")
        self.Context.timestamp = int(time.mktime(da.timetuple()))
        return table

    def run_surplus_metrics(self, arcadia_url, input_table=None, patch=None):
        if not input_table:
            input_table = self.Context.input_table_path

        task = RunSurplusMetrics(
                self,
                description="Child of task {}".format(self.id),
                component_name=self.Parameters.component_name,
                cluster = 'hahn',
                input_table_path = input_table,
                surplus_metric_path = arcadia_url,
                arcadia_patch=patch,
                metrics_mode=self.Parameters.metrics_mode,
                dont_use_cached_result = self.Parameters.is_release_machine_mode
            )
        task.enqueue()
        return task

    def prepare_yt_path(self, revision):
        import yt.wrapper as yt

        yt.config.set_proxy("hahn")
        yt.config["token"] = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
        yt.create('map_node', '//home/userdata-sessions-build-ci/rule_monitoring/{}/1'.format(revision), True, True)
        yt.create('map_node', '//home/userdata-sessions-build-ci/rule_monitoring/{}/2'.format(revision), True, True)
        yt.link('//home/logfeller/logs', '//home/userdata-sessions-build-ci/rule_monitoring/{}/1/logs'.format(revision), ignore_existing=True)
        yt.link('//home/logfeller/logs', '//home/userdata-sessions-build-ci/rule_monitoring/{}/2/logs'.format(revision), ignore_existing=True)

    def check_prepared_sessions(self, revision):
        import yt.wrapper as yt

        yt.config.set_proxy("hahn")
        yt.config["token"] = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
        old_sessions = yt.exists('//home/userdata-sessions-build-ci/rule_monitoring/{}/1/user_sessions/pub/search'.format(revision))
        new_sessions = yt.exists('//home/userdata-sessions-build-ci/rule_monitoring/{}/2/user_sessions/pub/search'.format(revision))
        return old_sessions & new_sessions

    def run_create_sessions(self, branch, input_table):
        params = {
            'exception_on_build_fail': False,
            'arcadia_url_with_revision': branch,
            'custom_whole_prefix_path': input_table,
            'custom_yt_pool': 'sessions-minor',
            'days_to_store_output': 7,
            'extra_labels_for_fast': 'search',
            'fast_datetime': self.Context.date_time,
            'fast_sessions_to_check': 'search',
            'fetch_path': 'home/userdata-sessions-build-ci/user-sessions-processes-ci/2016-12-12',
            'launch_daily': False,
            'launch_fast': True,
            'set_output_removal_attrs': True,
            'yt-token': 'CI-token',
        }
        create_sessions_task = sdk2.Task[UserSessionsProcessesTest.type](self, **params)
        task_id = create_sessions_task.enqueue().id
        return task_id

    def build_bin(self, branch):
        task = ReleaseUserSessionsBinaries(
                self,
                description="Child of task {}".format(self.id),
                component_name=self.Parameters.component_name,
                cluster='hahn',
                reg_customize_binaries = False,
                nonreg_customize_binaries = False,
                reg_general_arcadia_url = self.Parameters.new_revision,
                reg_nirvana_ttl_days = 365,
                reg_binaries_build_method = 'general_arcadia_url',
                nonreg_binaries_build_method = 'do_not_build',
                reactor_token_secret_owner = 'USERSESSIONSTOOLS',
                reactor_token_secret_name = 'prod_reactor_token',
                nirvana_token_secret_owner = 'USERSESSIONSTOOLS',
                nirvana_token_secret_name = 'prod_nirvana_token',
                nirvana_quota_name = 'user-sessions',
                build_only_one_binary = 'surplus_metrics',
            )
        task.RM_NOTIFY_STATUSES_DO_NOT_SEND = [const.RMStatus.on_success, const.RMStatus.on_break]
        self.Context.build_bin_task_id = task.id

        task.enqueue()
        return task

    def run_release_task(self):
        task = SurplusMetricsTaskReleaser(
                self,
                description="Child of task {}".format(self.id),
                sm_task_id = self.id,
            )
        task.enqueue()

    def release_result(self):
        if self.Parameters.just_testing_no_release:
            return
        last_released_branch_revision = self.get_revision(self.get_branch_from_last_released_resource())
        if last_released_branch_revision < self.get_revision(self.Parameters.new_revision):
            run_sm_task_id = self.Context.new_CS_new_SM_id if self.Parameters.is_release_machine_mode else self.Context.new_CS_old_SM_id
            self.server.release(
                task_id = run_sm_task_id,
                type="stable",
                subject="Release"
            )

            self.Context.released = True
            self.run_release_task()
        else:
            raise Exception("You try to release revision older than deployed on reactor")

    def get_revision(self, url):
        if url.count("@") != 1:
            return None
        return url.split("@")[-1]

    def create_simple_diff(self):
        logging.debug("Creating simple diff")
        if not self.Context.previous_commit_revision:
            self.Context.previous_commit_revision = self.Context.old_surplus_metrics_branch

        logging.debug("Creating simple diff between {} and {} and {}".format(self.Context.old_surplus_metrics_branch, self.Context.previous_commit_revision, self.Parameters.new_revision))
        input_table_path = self.Context.input_table_path
        input_table_path_for_new = self.Context.input_table_path_for_new_commit
        logging.debug("Using tables old {} new {} ".format(input_table_path, input_table_path_for_new))
        logging.debug("Fetching old_branch resource")
        baseline_surplus_metrics = self.find_surplus_metrics_resource("SM_BASELINE", revision=self.Context.old_surplus_metrics_branch, table_path=input_table_path, parent_task_id=self.Parameters.custom_old_CS_old_SM_id)
        logging.debug("Fetching previous commit resource")
        previous_commit_revision = self.find_surplus_metrics_resource("SM_PREV", revision=self.Context.previous_commit_revision, table_path=input_table_path, parent_task_id=self.Parameters.custom_old_CS_new_SM_id)
        logging.debug("Fetching checked commit resource")
        checked_commit = self.find_surplus_metrics_resource("SM_NEW", revision=self.Parameters.new_revision, table_path=input_table_path_for_new, parent_task_id=self.Parameters.custom_new_CS_old_SM_id)
        logging.debug("Starting differ")
        sm_differ = SurplusMetricsDiffHelper(baseline_surplus_metrics, previous_commit_revision, no_res = checked_commit)
        sm_differ.get_html(str(self.path('diff.html')), keep_OK_metrics=self.Parameters.show_OK_metrics)
        self.diff_to_resource(str(self.path('diff.html')))
        self.Context.has_diff = sm_differ.has_diff

    def find_surplus_metrics_resource(self, name, revision=None, table_path=None, parent_task_id=None):
        attrs = {}
        if parent_task_id:
            attrs['parent_task_id'] = parent_task_id
        if revision is not None:
            attrs["branch"] = revision
        if table_path is not None:
            attrs["table"] = table_path
        logging.debug("Searching with attrs {}".format(attrs))
        resource = SurplusMetricsResult.find(attrs=attrs).first()
        assert resource, "Can't find {} USER_SESSIONS_SURPLUS_METRICS_RESULT for revision {}".format(name,revision)

        return str(sdk2.ResourceData(resource).path)


    def create_diff_for_rm(self):
        old_CS_old_SM_res = self.find_surplus_metrics_resource('old_CS_old_SM', parent_task_id=self.Context.old_CS_old_SM_id)
        old_CS_new_SM_res = self.find_surplus_metrics_resource('old_CS_new_SM', parent_task_id=self.Context.old_CS_new_SM_id)
        new_CS_old_SM_res = self.find_surplus_metrics_resource('new_CS_old_SM', parent_task_id=self.Context.new_CS_old_SM_id)
        new_CS_new_SM_res = self.find_surplus_metrics_resource('new_CS_new_SM', parent_task_id=self.Context.new_CS_new_SM_id)
        sm_differ = SurplusMetricsDiffHelper(old_CS_old_SM_res, old_CS_new_SM_res, new_CS_old_SM_res, new_CS_new_SM_res)
        sm_differ.get_html(str(self.path('diff.html')), self.Parameters.show_OK_metrics)
        self.diff_to_resource(str(self.path('diff.html')))
        self.Context.has_diff = sm_differ.has_diff


    def diff_to_resource(self, path_to_all_diff):
        resource = UserSessionsSurplusMetricsInfo(
            self,
            "Surplus metrics output",
            str(path_to_all_diff),
            branch=self.Parameters.new_revision,
            table=self.Context.input_table_path
        )
        sdk2.ResourceData(resource)
        self.Context.diff_res_id = resource.id
        self.Context.imp_metr_diff_res_id = None

    def get_previous_revision(self):
        resources = SurplusMetricsResult.find().limit(100)
        max_revision = 0
        res_branch = None
        new_rev = self.get_revision(self.Parameters.new_revision)
        for res in resources:
            splited_branch = res.branch.split("@")
            if not len(splited_branch) == 2:
                continue
            rev = splited_branch[1]
            if not "branches" in res.branch and rev > max_revision and rev < new_rev:
                res_branch = res.branch
                max_revision = rev
        self.Context.previous_commit_revision = res_branch
        logging.info("$$$$$$ {}".format(res_branch))

    def get_branch_from_last_released_resource(self):
        last_released_res = sdk2.Resource.find(
                type= UserSessionsSurplusMetricsInfo,
            ).order(-sdk2.Resource.id).limit(50)
        for res in last_released_res:
            if sdk2.Resource[res.id].task.status in ctt.Status.RELEASED:
                logging.info('$$$$$$$$$$$$$$$${}'.format(res.id))
                return sdk2.Resource[res.id].branch
        raise Exception("No release in last 50 resources")

    def get_last_released_branch(self):
        if not self.Parameters.is_get_old_branch_auto and self.Parameters.old_revision:
            self.Context.old_surplus_metrics_branch = self.Parameters.old_revision
            return
        else:
            self.Context.old_surplus_metrics_branch = self.get_branch_from_last_released_resource()
            return
        raise Exception("No release in last 50 resources")

    def resolve_sessions_timestamp(self, revision):
        import yt.wrapper as yt
        yt.config.set_proxy("hahn")
        yt.config["token"] = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
        self.Context.sessions_timestamp_old = max(yt.list('//home/userdata-sessions-build-ci/rule_monitoring/{}/1/user_sessions/pub/search/fast'.format(revision)))
        self.Context.sessions_timestamp_new = max(yt.list('//home/userdata-sessions-build-ci/rule_monitoring/{}/2/user_sessions/pub/search/fast'.format(revision)))

    def send_notification_to_rm(self, message):
        logging.debug("Trying to send notifications to rm. message {}".format(message))
        if self.Parameters.just_testing_no_release:
            return
        UserSessionsHelper(
            self,
            description="Child of test task {}".format(self.id),
            branch_url=self.Parameters.new_revision,
            message=message,
            send_to_tg=True,
            send_to_st=True,
            release_num=self.Parameters.release_number,
            is_summon_people_to_st=True,
            add_duty_login=True,
            component_name=self.Parameters.component_name,
        ).enqueue()

    def set_expiration_time(self, table_path, delay=1440):
        import yt.wrapper as yt
        yt.config.set_proxy("hahn")
        yt.config["token"] = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
        utc_now = datetime.datetime.utcnow()
        delayed_time = utc_now + datetime.timedelta(minutes=int(delay))
        delayed_time_iso = delayed_time.isoformat() + 'Z'
        logging.info('delayed_time_iso delayed_time_iso delayed_time_iso {}'.format(delayed_time_iso))
        if not yt.exists(table_path):
            return
        yt.set(str(table_path) + '/@expiration_time', delayed_time_iso)

    def custom_change_child_task_id_if_needed(self, context_attr):
        if getattr(self.Parameters, "custom_" + context_attr) not in [ctm.NotExists, None, ""]:
            setattr(self.Context, context_attr, getattr(self.Parameters, "custom_" + context_attr))


    def create_run_surplus_metrics_task_if_needed(self, run_rule_context_attr, rule_monitoring_branch, cs_table):
        if not hasattr(self.Context, run_rule_context_attr) or (getattr(self.Context, run_rule_context_attr) in [None, "", ctm.NotExists]):
            new_task = self.run_surplus_metrics(rule_monitoring_branch, cs_table)
            setattr(self.Context, run_rule_context_attr, new_task.id)
            return [new_task]
        else:
            return []

    def customize_tables_path(self):
        if not self.Parameters.is_set_custom_table:
            return
        self.Context.input_table_path = self.Parameters.custom_table
        self.Context.input_table_path_for_new_commit = self.Parameters.custom_table_for_new_commit
        if self.Parameters.custom_table_for_new_commit:
            self.Context.input_table_path_for_new_commit = self.Context.input_table_path

    def should_use_manual_ids(self):
        return self.Parameters.custom_old_CS_new_SM_id is not None and self.Parameters.custom_old_CS_old_SM_id is not None and self.Parameters.custom_new_CS_old_SM_id is not None

    def on_execute(self):
        self.Context.input_table_path = self.get_sesions_path()
        self.Context.input_table_path_for_new_commit = self.Context.input_table_path
        self.get_last_released_branch()
        if self.Parameters.is_release_machine_mode:
            if not self.Parameters.release_number:
                raise ValueError("You need to set release_number")
            new_revision = self.get_revision(self.Parameters.new_revision)
            with self.memoize_stage.prepare_user_sessions:
                if not self.check_prepared_sessions(new_revision):
                    self.prepare_yt_path(new_revision)
                    self.Context.create_sessions_old = self.run_create_sessions(
                        self.Context.old_surplus_metrics_branch,
                        '//home/userdata-sessions-build-ci/rule_monitoring/{}/1'.format(new_revision))
                    self.Context.create_sessions_new = self.run_create_sessions(
                        self.Parameters.new_revision,
                        '//home/userdata-sessions-build-ci/rule_monitoring/{}/2'.format(new_revision))
                    raise sdk2.WaitTask([self.Context.create_sessions_old, self.Context.create_sessions_new], ctt.Status.Group.FINISH, wait_all=True)

            self.custom_change_child_task_id_if_needed("old_CS_old_SM_id")
            self.custom_change_child_task_id_if_needed("old_CS_new_SM_id")
            self.custom_change_child_task_id_if_needed("new_CS_new_SM_id")
            self.custom_change_child_task_id_if_needed("new_CS_old_SM_id")
            with self.memoize_stage.run_surplus_metrics:
                self.resolve_sessions_timestamp(new_revision)
                old_cs_table = '//home/userdata-sessions-build-ci/rule_monitoring/{}/1/user_sessions/pub/search/fast/{}/clean'.format(new_revision, self.Context.sessions_timestamp_old)
                new_cs_table = '//home/userdata-sessions-build-ci/rule_monitoring/{}/2/user_sessions/pub/search/fast/{}/clean'.format(new_revision, self.Context.sessions_timestamp_new)
                self.set_expiration_time('//home/userdata-sessions-build-ci/rule_monitoring/{}'.format(new_revision))

                tasks_to_wait = []
                tasks_to_wait += self.create_run_surplus_metrics_task_if_needed("old_CS_old_SM_id", self.Context.old_surplus_metrics_branch, old_cs_table)
                tasks_to_wait += self.create_run_surplus_metrics_task_if_needed("old_CS_new_SM_id", self.Parameters.new_revision, old_cs_table)
                tasks_to_wait += self.create_run_surplus_metrics_task_if_needed("new_CS_old_SM_id", self.Context.old_surplus_metrics_branch, new_cs_table)
                tasks_to_wait += self.create_run_surplus_metrics_task_if_needed("new_CS_new_SM_id", self.Parameters.new_revision, new_cs_table)

                if tasks_to_wait:
                    raise sdk2.WaitTask(
                        tasks_to_wait,
                        ctt.Status.Group.FINISH|ctt.Status.Group.BREAK,
                        wait_all=True)
            self.create_diff_for_rm()
        else:
            if not self.should_use_manual_ids():
                with self.memoize_stage.run_surplus_metrics:
                    self.get_previous_revision()
                    baseline_rule_monitoring = self.run_surplus_metrics(self.Context.old_surplus_metrics_branch)
                    previous_commit = self.run_surplus_metrics(self.Context.previous_commit_revision)
                    checked_rule_monitoring = self.run_surplus_metrics(self.Parameters.new_revision)
                    baseline_rule_monitoring.id
                    self.Context.new_CS_old_SM_id = checked_rule_monitoring.id
                    raise sdk2.WaitTask([baseline_rule_monitoring, previous_commit, checked_rule_monitoring], ctt.Status.Group.FINISH|ctt.Status.Group.BREAK, wait_all=True)

        self.customize_tables_path()

        if self.Parameters.is_release_machine_mode:
            self.create_diff_for_rm()
            if self.Context.has_diff:
                rm_message_template = (u"Surplus Metrics\n"
                                       u"DIFF - https://sandbox.yandex-team.ru/resource/{}/view \n"
                                       u"Прямая ссылка на html c DIFF https://proxy.sandbox.yandex-team.ru/{} \n")
                self.send_notification_to_rm(rm_message_template.format(self.Context.diff_res_id, self.Context.diff_res_id))

        else:
            self.create_simple_diff()
            if not self.Context.has_diff:
                self.release_result()
            else:
                message_template = (
                    u"После твоего коммита https://a.yandex-team.ru/arc/commit/{} был запущен diff на Surplus metrics.\n"
                    u"Таска в сендбокс https://sandbox.yandex-team.ru/task/{}/view\n"
                    u"Необходимо посмотреть DIFF между твоим коммитом, и версией Surplus metrics в production https://sandbox.yandex-team.ru/resource/{}/view \n"
                    u"Прямая ссылка на html c diff https://proxy.sandbox.yandex-team.ru/{}\n"
                    u"Если дифф ожидаемый - ничего делать не надо, мы уже зарелизили код на veles02.\n"
                    u"Если дифф НЕ ожидаем, то необходимо разобраться, что изменилось и либо откатить, либо исправить баг\n"
                    u"Если остались какие-то вопросы - напиши на logs-team@yandex-team.ru")
                commit_author = self.Parameters.commit_author if self.Parameters.commit_author else self.author
                self.server.notification(
                    subject='You need to check surplus-metrics',
                    body=message_template.format(self.get_revision(self.Parameters.new_revision), self.id, self.Context.diff_res_id, self.Context.diff_res_id, self.id),
                    recipients=[commit_author, 'kkhamitov'],
                    transport=ctn.Transport.EMAIL,
                    urgent=True,
                )
                self.release_result()

        if self.Context.diff_res_id:
            self.set_info('Result diff file - ((https://sandbox.yandex-team.ru/resource/{}/view))'.format(self.Context.diff_res_id))
        else:
            self.set_info('Empty diff')

