# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.process import run_process
import sandbox.projects.common.constants as consts
from sandbox.projects.common.arcadia import sdk
import sandbox.projects.release_machine.input_params2 as rm_params
import sandbox.common.types.resource as ctr
from sandbox.common.types import task as ctt
from sandbox.projects.yql.RunYQL2 import RunYQL2

import datetime
import os
import json
import logging
import yql_script
from yql_script import yql_script_data

SURPLUS_METRICS_PATH = 'quality/user_metrics/surplus_metrics'
YQL_TOKEN_OWNER = 'USERSESSIONSTOOLS'
YQL_TOKEN_NAME = 'userdata-sessions-build-ci-token'


# Warning! It's a copy-paste of RunRuleMonitoring task, should be refactored in the scope of LOGS-2126
class SurplusMetricsBinary(sdk2.Resource):
    """
       Surplus Metrics bin
    """
    releasable = False
    any_arch = True
    executable = True
    auto_backup = True
    branch = sdk2.parameters.String()
    parent_task_id = sdk2.parameters.String()


class SurplusMetricsResult(sdk2.Resource):
    """
        File with Surplus metrics resultresult
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True
    branch = sdk2.parameters.String()
    table = sdk2.parameters.String()
    parent_task_id = sdk2.parameters.String()


class RunSurplusMetrics(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = [environments.PipEnvironment('yandex-yt', version='0.10.8')]
        cores = 1
        ram = 4096
        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(rm_params.ComponentName2):
        with sdk2.parameters.RadioGroup("Cluster name") as cluster:
            cluster.values.hahn = cluster.Value("hahn", default=True)
            cluster.values.arnold = cluster.Value("arnold")

        with sdk2.parameters.RadioGroup("metrics mode") as metrics_mode:
            metrics_mode.values.summary = metrics_mode.Value("summary", default=True)
            metrics_mode.values.full = metrics_mode.Value("full")

        input_table_path = sdk2.parameters.String(
            'input_table_path',
            description='Path for input table',
            multiline=False,
            required=True
        )
        surplus_metric_path = sdk2.parameters.ArcadiaUrl('Arcadia url for surplus metrics', required=True)
        arcadia_patch = sdk2.parameters.String('Patch for tasks', required=False, default=None)
        dont_use_cached_result = sdk2.parameters.Bool("Don't use cached result resource", required=False, default=False)

    def clone_and_build(self, arcadia_url, api, result_dir, patch=None):
        arcadia_dir = sdk.do_clone(arcadia_url, self)
        sdk.do_build(
             build_system=consts.YMAKE_BUILD_SYSTEM,
             source_root=arcadia_dir,
             targets=[api],
             build_type=consts.RELEASE_BUILD_TYPE,
             results_dir=str(result_dir),
             clear_build=False,
             use_dev_version=False,
             sanitize=False,
             checkout=True,
             patch=patch
         )

    def prepare_result_file_as_resource(self, path):
        sdk2.ResourceData(SurplusMetricsResult(
            self,
            "Surplus metrics output",
            str(path),
            branch=self.Parameters.surplus_metric_path,
            parent_task_id=self.id,
            table=self.Parameters.input_table_path,
        ))

    def prepare_bin_as_resource(self, path):
        sdk2.ResourceData(SurplusMetricsBinary(
            self,
            "Surplus metrics bin",
            str(path),
            branch=self.Parameters.surplus_metric_path,
            parent_task_id=self.id,
        ))

    def search_bin(self):
        try:
            resource = SurplusMetricsBinary.find(attrs=dict(branch=self.Parameters.surplus_metric_path)).first()
            if resource:
                self.Context.use_bin_from_res = True
                return str(sdk2.ResourceData(resource).path)
        except:
            return None
        return None

    def search_prepared_rm_result(self):
        if self.Parameters.arcadia_patch is not None:
            return None
        resource = SurplusMetricsResult.find(attrs=dict(
            branch = self.Parameters.surplus_metric_path,
            table = self.Parameters.input_table_path,
        )).first()
        if self.Parameters.dont_use_cached_result:
            return None
        if resource:
            self.Context.use_prepared_rm_res = True
            return str(sdk2.ResourceData(resource).path)
        return None

    def read_table(self, yt_path, file_name):
        import yt.wrapper as yt
        yt.config["proxy"]["url"] = "hahn"
        yt.config["token"] = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
        records = list(yt.read_table(yt_path, format=yt.JsonFormat(), raw=True))
        with open(str(file_name), 'w') as f:
            f.write(''.join(records))

    def DoSyncBDict(self):
        resource = sdk2.Resource["SESSIONS_BLOCKSTAT"].find(state=ctr.State.READY).first()
        try:
            self.Context.res_bdict = str(resource)
        except Exception:
            try:
                self.Context.res_bdict = resource.id
            except Exception:
                self.Context.res_bdict = "nothing"
        resource_data = sdk2.ResourceData(resource)
        resource_path = resource_data.path
        p = sdk2.path.Path(resource_path)

        return str(p)



    def set_expiration_time(self, table_path, delay=1440):
        import yt.wrapper as yt
        yt.config.set_proxy('hahn')
        yt.config['token'] = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
        utc_now = datetime.datetime.utcnow()
        delayed_time = utc_now + datetime.timedelta(minutes=int(delay))
        delayed_time_iso = delayed_time.isoformat() + 'Z'
        logging.info('delayed_time_iso delayed_time_iso delayed_time_iso {}'.format(delayed_time_iso))
        if not yt.exists(table_path):
            return
        yt.set(str(table_path) + '/@expiration_time', delayed_time_iso)


    def run_yql_scripts(self, table_path):
        subtasks = []
        for script_template in [yql_script_data]:
            script = script_template.format(table_path=table_path);
            subtask = RunYQL2(
                                self,
                                description='Filtering meaningful surplus-metrics in {}'.format(table_path),
                                create_sub_task=True,
                                query=script,
                                trace_query=True,
                                use_v1_syntax=True,
                                )
            subtask.enqueue()
            subtasks.append(subtask)
        self.Context.metrics_aggregated = True
        raise sdk2.WaitTask(subtasks,  ctt.Status.Group.FINISH | ctt.Status.Group.BREAK, wait_all=True)

    def on_execute(self):
        prep_res = self.search_prepared_rm_result()
        if not prep_res:
            self.token = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
            os.environ['YT_TOKEN'] = self.token
            result_path = self.path('builded')
            work_dir = str(self.path())
            surplus_metric_bin_path = self.search_bin()
            work_dir = str(result_path) + '/' + SURPLUS_METRICS_PATH
            self.clone_and_build(self.Parameters.surplus_metric_path, SURPLUS_METRICS_PATH, result_path, self.Parameters.arcadia_patch)
            surplus_metric_bin_path = str(work_dir)+'/surplus_metrics'


            table_path = '//home/userdata-sessions-build-ci/surplus-metrics/{}/samples'.format(self.id)
            parent_table_path = '//home/userdata-sessions-build-ci/surplus-metrics/{}'.format(self.id)
            if not self.Context.metrics_calculated:
                logging.info('Running metrics bin')
                run_process(
                    [surplus_metric_bin_path,
                    '-u', self.Parameters.input_table_path,
                    '-s',
                    '-v v6.b',
                    '-m mr',
                    '-b', self.DoSyncBDict(),
                    '-o', table_path],
                    work_dir=work_dir,
                    shell=True,
                    timeout=10000,
                    log_prefix='run_surplus_metrics',
                    outputs_to_one_file=True
                )
                self.Context.metrics_calculated = True

            self.set_expiration_time(table_path)
            self.set_expiration_time(parent_table_path)
            if not self.Context.metrics_aggregated and self.Parameters.metrics_mode != 'summary':
                self.run_yql_scripts(table_path)

            if not self.Context.use_bin_from_res and not self.Parameters.arcadia_patch:
                self.prepare_bin_as_resource(str(work_dir)+'/surplus_metrics')

            metrics_table_path = table_path + '/all_summary'
            if self.Parameters.metrics_mode != 'summary':
                metrics_table_path = table_path + '/grepped_metrics'
                self.set_expiration_time(metrics_table_path)

            self.read_table(yt_path=metrics_table_path, file_name=self.path('res.txt'))
            self.prepare_result_file_as_resource(self.path('res.txt'))
