# -*- coding: utf-8 -*-

import datetime

from sandbox import sdk2
from sandbox.projects.common import task_env
from sandbox.common.utils import server_url
from sandbox.sandboxsdk.environments import PipEnvironment

import sandbox.projects.geobase.Geodata6BinXurmaStable.resource as geo_resource

YT_PATH = '//home/user_sessions/resources/versioned/geodata6-xurma.bin'
YT_ATTR_BUILT_BY = 'built_by'
YT_PROXIES = ['markov']


class StatboxGeodataUploadToYT(sdk2.Task):
    """загрузка geodata6-xurma.bin на YT"""

    class Parameters(sdk2.Parameters):
        token = sdk2.parameters.YavSecret(
            "YAV secret identifier (with optional version)",
            default="sec-01daxfs11zg96x6vwey9pg5q5n#secret"
        )

    class Requirements(task_env.TinyRequirements):
        disk_space = 2 * 1024  # 2 Gb
        environments = PipEnvironment('yandex-yt'),

    def on_execute(self):
        import yt.wrapper as yt

        geodata_path = str(sdk2.ResourceData(sdk2.Resource.find(geo_resource.GEODATA6BIN_XURMA_STABLE, attrs={'released': 'stable'}).limit(1).first()).path)

        today_date = datetime.date.today().strftime('%Y-%m-%d')
        remove_date = (datetime.date.today() - datetime.timedelta(days=2)).strftime('%Y-%m-%d')
        self.set_info('YT path: {}/{}'.format(YT_PATH, today_date))
        self.set_info('Remove YT path: {}/{}'.format(YT_PATH, remove_date))
        sandbox_www = server_url()
        yt.config['token'] = self.Parameters.token.data()[self.Parameters.token.default_key]

        for proxy in YT_PROXIES:
            yt.config['proxy']['url'] = '{}.yt.yandex.net'.format(proxy)
            yt.smart_upload_file(geodata_path, destination='{}/{}'.format(YT_PATH, today_date), placement_strategy='replace')
            yt.set('{}/{}/@{}'.format(YT_PATH, today_date, YT_ATTR_BUILT_BY), '{}/task/{}'.format(sandbox_www, self.id))
            yt.link('{}/{}'.format(YT_PATH, today_date), '//home/user_sessions/resources/geodata6-xurma.bin', ignore_existing=False, force=True)
            yt.remove('{}/{}'.format(YT_PATH, remove_date))
            self.set_info('{}: OK'.format(proxy))
